/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef GAMEWIDGET_H
#define GAMEWIDGET_H

#include <qwidget.h>
#include <qpixmap.h>
#include <qtimer.h>

#include "config.h"
#include "fish.h"
#include "net.h"
#include "fireworks.h" 
#include "stopwatch.h"
#include "StringDisplay.h"

#include "ScoreMng.h"
#include "HiScoreReg.h"
#include "levelSelector.h"
#include "Display.h"


class CGameWidget : public QWidget
{
    Q_OBJECT

public:
    CGameWidget(QWidget *parent, const char *name = 0, WFlags f = 0);
    ~CGameWidget();
    static CStringDisplay *m_pStringDisp;

private:
    QTimer *m_timer;
    QPixmap *m_pixmap;
    QPixmap m_bug[2];

    Cnet* m_netObj;

    int m_allfish;	   // max fish count
    int m_freefish;	   // free fish count
    char m_gamemode;	   // 0:title 1:game 2:gameover
    char m_level;          // Game Level
    long starttime;	   // start time
    long cleartime; 	   // clear time
    int m_DispStayTime;    // display interval

    CFireWorks *m_pfireworks[3];

    CFish *m_pfish[FISH_NUM];
    CStopWatch m_stopwatch;

    //For Hi-score
    CScoreMng *m_pScoreMng[2];// 0:EASY 1:HARD
    CHiScoreReg *m_pHiScoreReg;

    // Level Selector
    CLevelSelector m_levelselector;
    // start button
    CButton* m_pstartBtn;

    //    int m_count;

    CDisplay *m_pDisplay;

public slots:
    void timerTick(void);

protected:
    void paintEvent(QPaintEvent *event);
    void resizeEvent(QResizeEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);

private:
    void clearGame();
    void setNewGame();
    void paint(void);
    void intoWater(void);
    void pickUpWater(void);
    void setGameOverMsg(QPainter *paint);
    void drawPixmapText(QPainter &painter, int x, int y, int wrap, const char *str);
    void drawFish( QPainter *paint, bool bNetInWater = false );
    void registHiScoreData( bool IsHard );
    CScoreMng *getCurrentScoreMng();
    void setUpWHFish( CFish *fish );
    void setUpBlackFish( CFish *fish );
    void setUpHitArea( CFish *fish, int type );
    int  choiceFish();
    void initFishSpeed( int level );
};

#endif


