/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <qcolor.h>
#include "net.h"
#include "areaSize.h"


Cnet::Cnet(PIXMAP *img, int damage)
{
  m_pnetBMP = &img[0];
  m_pnetInWaterBMP = &img[1];
  m_pnetBreakBMP = &img[2];

  m_HitArea = new CHitArea( NET_HIT_AREA );
  
  init(0,0,damage);

}

Cnet::~Cnet()
{
  delete m_HitArea;
}

void Cnet::draw(PAINTER* painter)
{

	PIXMAP *pbitmap;

	if(m_damage > 0){

		if(m_inwater){
			// in water..
			pbitmap = m_pnetInWaterBMP;
		} else {
			pbitmap = m_pnetBMP;
		}

	} else {
		pbitmap = m_pnetBreakBMP;
	}

	painter->drawPixmap(m_pos_x,m_pos_y, *pbitmap);

}
//
// decrement net limit
//
bool Cnet::minusdamage()
{
	bool ret;

	m_damage--;

	if(m_damage <= 0){
		m_damage = 0;
		ret = true;
	} else {
		ret = false;
	}

	return ret;

}
bool Cnet::minusdamage(int damage)
{
	bool ret;

	m_damage -= damage;

	if(m_damage <= 0){
		m_damage = 0;
		ret = true;
	} else {
		ret = false;
	}

	return ret;  
}
void Cnet::setinwater(bool status)
{

  m_inwater = status;

}

bool Cnet::isInWater()
{
	return m_inwater;
}

void Cnet::setdamage(int dmg)
{
	m_damage = dmg;

	if(m_damage <= 0){
		m_inwater = false;
	}

}
int Cnet::getdamage(void)
{
  return m_damage;
}
void Cnet::init(int x, int y, int damage)
{
  m_damagemax = damage;
  m_damage = damage;
  m_inwater = false;
  setPos(x,y);

}
void Cnet::drawDamageBar(PAINTER *paint, int x, int y, int width, int colorheight)
{

  QColor rgb(0,0,0);
  int colorNum = 8;
  int fillLength;
  int r,g,b;
  int i;

  rgb.setRgb(0,0,0);
  paint->fillRect(x, y, width, colorNum * colorheight, rgb );

  r = 247;
  g = 189;
  b = 251;
	
  fillLength = (int)( (double)width * (double)m_damage / (double)m_damagemax );
  for( i=0; i<colorNum; i++){
    rgb.setRgb(r,g,b);
    paint->fillRect(x, y, fillLength, colorheight, rgb );
    y += colorheight;
    r -= 3;
    g -= 20;
    b -= 2;
  }


}
CHitArea Cnet::GetHitArea()
{
  return *m_HitArea;
}
void Cnet::setPos(int x,int y)
{
  CSprite::setPos( x, y );
  m_HitArea->SetBasePos( x, y );
}
