/*
 * Decompiled with CFR 0.152.
 */
package trail.interceptor;

import java.io.Serializable;
import java.util.ArrayList;
import javax.ejb.AroundInvoke;
import javax.ejb.Interceptors;
import javax.ejb.InvocationContext;
import javax.ejb.Stateful;
import trail.interceptor.Calculator;
import trail.interceptor.Tracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateful
@Interceptors(value={Tracer.class})
public class InterceptorCalculator
implements Calculator,
Serializable {
    public ArrayList<Integer> starts = new ArrayList();
    public ArrayList<Integer> ends = new ArrayList();
    public ArrayList<Double> growthrates = new ArrayList();
    public ArrayList<Double> savings = new ArrayList();
    public ArrayList<Double> results = new ArrayList();
    private String trace;

    @Override
    public double calculate(int start, int end, double growthrate, double saving) {
        double tmp = Math.pow(1.0 + growthrate / 12.0, 12.0 * (double)(end - start) + 1.0);
        double result = saving * 12.0 * (tmp - 1.0) / growthrate;
        this.starts.add(start);
        this.ends.add(end);
        this.growthrates.add(growthrate);
        this.savings.add(saving);
        this.results.add(result);
        return result;
    }

    @Override
    public ArrayList<Integer> getStarts() {
        return this.starts;
    }

    @Override
    public ArrayList<Integer> getEnds() {
        return this.ends;
    }

    @Override
    public ArrayList<Double> getGrowthrates() {
        return this.growthrates;
    }

    @Override
    public ArrayList<Double> getSavings() {
        return this.savings;
    }

    @Override
    public ArrayList<Double> getResults() {
        return this.results;
    }

    @AroundInvoke
    public Object limitStateSize(InvocationContext ctx) throws Exception {
        if (this.starts.size() > 4) {
            this.starts.remove(0);
            this.ends.remove(0);
            this.growthrates.remove(0);
            this.savings.remove(0);
            this.results.remove(0);
        }
        return ctx.proceed();
    }

    @Override
    public void setTrace(String s) {
        this.trace = s;
    }

    @Override
    public String getTrace() {
        return this.trace;
    }
}

