/*
 * Decompiled with CFR 0.152.
 */
package trail.lifecycle;

import java.io.Serializable;
import java.util.ArrayList;
import javax.ejb.PostActivate;
import javax.ejb.PostConstruct;
import javax.ejb.PreDestroy;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import trail.lifecycle.Calculator;
import trail.lifecycle.SessionRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateful
public class SessionCalculator
implements Calculator,
Serializable {
    public ArrayList<Integer> starts;
    public ArrayList<Integer> ends;
    public ArrayList<Double> growthrates;
    public ArrayList<Double> savings;
    public ArrayList<Double> results;

    @PostConstruct
    public void initialize() {
        System.err.println("Init is called");
        this.starts = new ArrayList();
        this.ends = new ArrayList();
        this.growthrates = new ArrayList();
        this.savings = new ArrayList();
        this.results = new ArrayList();
        ++SessionRecord.totalSess;
        ++SessionRecord.activeSess;
    }

    @PreDestroy
    public void exit() {
        System.err.println("exit is called");
        --SessionRecord.activeSess;
    }

    @PrePassivate
    public void serialize() {
        System.err.println("serialize is called");
        ++SessionRecord.pausedSess;
    }

    @PostActivate
    public void activate() {
        System.err.println("activate is called");
        --SessionRecord.pausedSess;
    }

    @Override
    @Remove
    public void stopSession() {
    }

    @Override
    public double calculate(int start, int end, double growthrate, double saving) {
        double tmp = Math.pow(1.0 + growthrate / 12.0, 12.0 * (double)(end - start) + 1.0);
        double result = saving * 12.0 * (tmp - 1.0) / growthrate;
        this.starts.add(start);
        this.ends.add(end);
        this.growthrates.add(growthrate);
        this.savings.add(saving);
        this.results.add(result);
        return result;
    }

    @Override
    public ArrayList<Integer> getStarts() {
        return this.starts;
    }

    @Override
    public ArrayList<Integer> getEnds() {
        return this.ends;
    }

    @Override
    public ArrayList<Double> getGrowthrates() {
        return this.growthrates;
    }

    @Override
    public ArrayList<Double> getSavings() {
        return this.savings;
    }

    @Override
    public ArrayList<Double> getResults() {
        return this.results;
    }
}

