/*
 * Decompiled with CFR 0.152.
 */
package trail.security;

import java.sql.Timestamp;
import java.util.Collection;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jboss.annotation.security.SecurityDomain;
import trail.entity.beans.Fund;
import trail.entity.beans.Investor;
import trail.entity.beans.TimedRecord;
import trail.security.Calculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@SecurityDomain(value="other")
public class SecureCalculator
implements Calculator {
    @PersistenceContext
    protected EntityManager em;

    @Override
    @RolesAllowed(value={"AdminUser"})
    public void addFund(String name, double growthrate) {
        Fund fund = new Fund(name, growthrate);
        this.em.persist((Object)fund);
    }

    @Override
    @RolesAllowed(value={"AdminUser"})
    public void addInvestor(String name, int start, int end) {
        Investor investor = new Investor(name, start, end);
        this.em.persist((Object)investor);
    }

    @Override
    @PermitAll
    public Collection<Fund> getFunds() {
        return this.em.createQuery("from Fund f").getResultList();
    }

    @Override
    @PermitAll
    public Collection<Investor> getInvestors() {
        return this.em.createQuery("from Investor p").getResultList();
    }

    @Override
    @PermitAll
    public Collection<TimedRecord> getRecords() {
        return this.em.createQuery("from TimedRecord r order by r.id desc").getResultList();
    }

    @Override
    @RolesAllowed(value={"RegularUser"})
    public double calculate(int fundId, int investorId, double saving) {
        Investor investor = (Investor)this.em.find(Investor.class, (Object)investorId);
        Fund fund = (Fund)this.em.find(Fund.class, (Object)fundId);
        int start = investor.getStartAge();
        int end = investor.getEndAge();
        double growthrate = fund.getGrowthrate();
        double tmp = Math.pow(1.0 + growthrate / 12.0, 12.0 * (double)(end - start) + 1.0);
        double result = saving * 12.0 * (tmp - 1.0) / growthrate;
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        TimedRecord rec = new TimedRecord(fund, investor, saving, result, ts);
        this.em.persist((Object)rec);
        return result;
    }
}

