/*
 * Decompiled with CFR 0.152.
 */
package trail.entity.query;

import java.util.Collection;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import trail.entity.beans.Fund;
import trail.entity.beans.Investor;
import trail.entity.beans.TimedRecord;
import trail.entity.query.Calculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class QueryCalculator
implements Calculator {
    @PersistenceContext
    protected EntityManager em;

    @Override
    public Collection<Fund> getFunds() {
        return this.em.createQuery("from Fund f").getResultList();
    }

    @Override
    public Collection<Investor> getInvestors() {
        return this.em.createQuery("from Investor p").getResultList();
    }

    @Override
    public Collection<TimedRecord> getRecords() {
        return this.em.createQuery("from TimedRecord r order by r.id desc").getResultList();
    }

    @Override
    public Collection<TimedRecord> filterRecords(double low, double high) {
        return this.em.createQuery("from TimedRecord r where r.result > :low AND r.result < :high").setParameter("low", (Object)new Double(low)).setParameter("high", (Object)new Double(high)).getResultList();
    }
}

