/*
 * Decompiled with CFR 0.152.
 */
package trail.injection;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.annotation.Resource;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TimerService;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.sql.DataSource;
import trail.injection.CalculationRecord;
import trail.injection.RecordManager;

@Stateless
public class RecordManagerBean
implements RecordManager {
    @Resource(mappedName="java:/DefaultDS")
    DataSource myDb;
    @Resource(mappedName="ConnectionFactory")
    QueueConnectionFactory factory;
    @Resource(mappedName="queue/testQueue")
    Queue queue;
    @Resource
    TimerService tms;
    @Resource
    SessionContext ctx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(long sent, double result) {
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.myDb.getConnection();
            pstmt = conn.prepareStatement("INSERT INTO INJECTIONREC (SENT,PROCESSED,RESULT) VALUES (?, ?, ?)");
            pstmt.setLong(1, sent);
            long processed = System.currentTimeMillis();
            pstmt.setLong(2, processed);
            pstmt.setDouble(3, result);
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                pstmt.close();
                conn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CalculationRecord getRecord(long sent) {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        CalculationRecord rc = null;
        try {
            conn = this.myDb.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT * FROM INJECTIONREC");
            while (rs.next()) {
                if (rs.getLong("sent") != sent) continue;
                rc = new CalculationRecord(rs.getLong("sent"), rs.getLong("processed"), rs.getDouble("result"));
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rc;
    }
}

