/*
 * Decompiled with CFR 0.152.
 */
package trail.apptrans;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import trail.apptrans.Calculator;
import trail.entity.beans.TimedRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateful
public class ApptransCalculator
implements Calculator,
Serializable {
    @PersistenceContext(type=PersistenceContextType.EXTENDED)
    protected EntityManager em;
    Collection<TimedRecord> rc;

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    protected void retrieveRecords() {
        this.rc = this.em.createQuery("from TimedRecord r order by r.id desc").getResultList();
    }

    @Override
    public Collection<TimedRecord> getRecords() {
        this.retrieveRecords();
        return this.rc;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void updateExchangeRate(double newrate) {
        if (this.rc == null) {
            System.out.println("This might indicate a problem");
            this.retrieveRecords();
        }
        for (TimedRecord r : this.rc) {
            r.setSaving(r.getSaving() * newrate);
            r.setResult(r.getResult() * newrate);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void updateTimestamp() {
        if (this.rc == null) {
            System.out.println("This might indicate a problem");
            this.retrieveRecords();
        }
        for (TimedRecord r : this.rc) {
            r.setTs(new Timestamp(System.currentTimeMillis()));
        }
    }

    @Override
    @Remove
    public void checkout() {
        this.em.flush();
    }
}

