/*
 * Decompiled with CFR 0.152.
 */
package trail.interceptor;

import javax.ejb.AroundInvoke;
import javax.ejb.InvocationContext;
import trail.interceptor.InterceptorCalculator;

public class Tracer {
    @AroundInvoke
    public Object log(InvocationContext ctx) throws Exception {
        InterceptorCalculator cal = (InterceptorCalculator)ctx.getBean();
        String className = ctx.getBean().getClass().getName();
        String methodName = ctx.getMethod().getName();
        String target = className + "." + methodName + "()";
        long start = System.currentTimeMillis();
        System.out.println("Invoking " + target);
        cal.setTrace(cal.getTrace() + "<br/>" + "Invoking " + target);
        try {
            Object object = ctx.proceed();
            return object;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            System.out.println("Exiting " + target);
            cal.setTrace(cal.getTrace() + "<br/>" + "Exiting " + target);
            long time = System.currentTimeMillis() - start;
            System.out.println("This method takes " + time + "ms to execute");
            cal.setTrace(cal.getTrace() + "<br/>" + "This method takes " + time + "ms to execute");
        }
    }
}

