/*
 * Decompiled with CFR 0.152.
 */
package trail.mdpojo;

import java.sql.Timestamp;
import javax.ejb.ActivationConfigProperty;
import org.jboss.annotation.ejb.Consumer;
import trail.mdpojo.Calculator;
import trail.mdpojo.RecordManager;

@Consumer(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/mdpojo")})
public class MdpojoCalculator
implements Calculator {
    public void doCalculation(long sent, int start, int end, double growthrate, double saving) {
        double result = this.calculate(start, end, growthrate, saving);
        RecordManager.addRecord(new Timestamp(sent), result);
        System.out.println("The MD POJO is invoked");
    }

    private double calculate(int start, int end, double growthrate, double saving) {
        double tmp = Math.pow(1.0 + growthrate / 12.0, 12.0 * (double)(end - start) + 1.0);
        return saving * 12.0 * (tmp - 1.0) / growthrate;
    }
}

