/*
 * Decompiled with CFR 0.152.
 */
package trail.transaction;

import java.util.Collection;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import trail.entity.beans.TimedRecord;
import trail.transaction.Calculator;
import trail.transaction.TransException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class TransCalculator
implements Calculator {
    @PersistenceContext
    protected EntityManager em;

    @Override
    public Collection<TimedRecord> getRecords() {
        return this.em.createQuery("from TimedRecord r order by r.id desc").getResultList();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void updateExchangeRate(double newrate) throws Exception {
        List rc = this.em.createQuery("from TimedRecord r").getResultList();
        int size = rc.size();
        for (TimedRecord r : rc) {
            r.setSaving(r.getSaving() * newrate);
            r.setResult(r.getResult() * newrate);
            double prob = Math.pow(0.5, 1.0 / (double)size);
            if (!(Math.random() > prob)) continue;
            throw new TransException();
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void updateExchangeRate2(double newrate) throws Exception {
        List rc = this.em.createQuery("from TimedRecord r").getResultList();
        for (TimedRecord r : rc) {
            r.setSaving(r.getSaving() * newrate);
            r.setResult(r.getResult() * newrate);
            int status = (int)(Math.random() * 4.0);
            System.err.println("status is " + status);
            if (status == 3) {
                throw new RuntimeException("Emulated database failure");
            }
            this.em.flush();
        }
    }
}

