package org.dyndns.nuda.tools.regex;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import org.dyndns.nuda.tools.regex.annotation.Regex;
import org.dyndns.nuda.tools.regex.annotation.RegexItem;
import org.dyndns.nuda.tools.util.ReflectUtil;

/**
 * 正規表現解析Bean(Regexアノテーションが付加されたBean)に対して
 * 解析結果を提供するための正規表現プロセッサです
 * 
 * @author nkoseki
 * 
 */
public class RegexProcessor {
	//	private static Logger				logger	= LoggerFactory
	//														.getLogger("RegexProcessor");
	
	private static Map<String, Pattern>	cache	= new HashMap<String, Pattern>();
	
	/**
	 * 引数に指定された解析対象テキストを正規表現で解析し、第二引数に指定されたクラスオブジェクトのインスタンスに<br />
	 * 結果を格納します
	 * 
	 * @param <T>
	 * @param source
	 * @param cls
	 * @return
	 */
	public <T> List<T> process(final String source, final Class<T> cls) {
		List<T> resultList = new ArrayList<T>();
		if (source == null) {
			//			logger.error("source is null");
			return resultList;
		}
		if (cls == null) {
			//			logger.error("process class is null");
			return resultList;
		}
		if (!cls.isAnnotationPresent(Regex.class)) {
			//			logger.error("process class invalid");
			return resultList;
		}
		
		//int flg = Pattern.DOTALL | Pattern.MULTILINE;
		
		Regex regex = cls.getAnnotation(Regex.class);
		
		int flg = 0;
		if (regex.isMultiLine()) {
			flg = flg | Pattern.MULTILINE;
		}
		if (regex.isDoTall()) {
			flg = flg | Pattern.DOTALL;
		}
		if (regex.isCaseInsentive()) {
			flg = flg | Pattern.CASE_INSENSITIVE;
		}
		if (regex.isComments()) {
			flg = flg | Pattern.COMMENTS;
		}
		if (regex.isLiteral()) {
			flg = flg | Pattern.LITERAL;
		}
		if (regex.isUnixLines()) {
			flg = flg | Pattern.UNIX_LINES;
		}
		if (regex.isUnicodeCase()) {
			flg = flg | Pattern.UNICODE_CASE;
		}
		if (regex.isCanonEq()) {
			flg = flg | Pattern.CANON_EQ;
		}
		
		try {
			Pattern pattern = null;
			if (cache.containsKey(regex.pattern())) {
				pattern = cache.get(regex.pattern());
			} else {
				if (flg != 0) {
					pattern = Pattern.compile(regex.pattern(), flg);
				} else {
					pattern = Pattern.compile(regex.pattern());
				}
				
				cache.put(regex.pattern(), pattern);
			}
			
			Matcher matcher = pattern.matcher(source);
			
			List<Field> fields = ReflectUtil.getAnnotationPresentedField(cls,
					RegexItem.class);
			
			Map<Integer, Field> fieldMap = new HashMap<Integer, Field>();
			
			for (Field f : fields) {
				fieldMap.put(f.getAnnotation(RegexItem.class).groupIndex(), f);
			}
			
			while (matcher.find()) {
				T instance = cls.newInstance();
				
				for (Entry<Integer, Field> entry : fieldMap.entrySet()) {
					Field targetField = fieldMap.get(entry.getKey());
					if (targetField != null) {
						Class<?> fieldType = targetField.getType();
						
						if (fieldType.equals(String.class)) {
							// インジェクション対象フィールドがStringの場合
							targetField.set(instance,
									matcher.group(entry.getKey()));
						} else if (fieldType.equals(List.class)) {
							// インジェクション対象フィールドがListの場合
							ParameterizedType paramType = (ParameterizedType) targetField
									.getGenericType();
							
							Type[] types = paramType.getActualTypeArguments();
							
							Class<?> componentType = (Class<?>) types[0];
							
							if (componentType.equals(String.class)) {
								
								RegexItem subRegexItem = targetField
										.getAnnotation(RegexItem.class);
								String subPatternStr = subRegexItem.pattern();
								int subindex = subRegexItem.subindex();
								
								if ((subindex > -1) && (subPatternStr != null)
										&& (!subPatternStr.isEmpty())) {
									List<String> subList = new ArrayList<String>();
									
									String subSource = matcher.group(entry
											.getKey());
									
									Pattern subPattern = Pattern.compile(
											subPatternStr, flg);
									Matcher subMatcher = subPattern
											.matcher(subSource);
									
									while (subMatcher.find()) {
										String subResult = subMatcher
												.group(subindex);
										if (subResult != null
												&& !subResult.isEmpty()) {
											subList.add(subResult);
										} else {
										}
									}
									
									targetField.set(instance, subList);
									
								} else {
									
								}
								
							} else {
								
								if (componentType
										.isAnnotationPresent(Regex.class)) {
									// componentTypeにRegexアノテーションが付加されている場合のみ処理対象とする/
									String subSource = matcher.group(entry
											.getKey());
									
									//									Regex subRegex = componentType
									//											.getAnnotation(Regex.class);
									
									List<?> subList = this.process(subSource,
											componentType);
									
									if (subList.size() > 0) {
										targetField.set(instance, subList);
									} else {
										// 1件もマッチしない場合はunmatchrefを参照して
										// 値の格納を行う
										
										RegexItem refSource = targetField
												.getAnnotation(RegexItem.class);
										if (!refSource.unmatcherRef().isEmpty()) {
											String unmatcherRef = refSource
													.unmatcherRef();
											try {
												Field unmatcherRefField = cls
														.getDeclaredField(unmatcherRef);
												
												if (unmatcherRefField.getType()
														.equals(String.class)) {
													unmatcherRefField
															.set(instance,
																	subSource);
												}
												
											} catch (SecurityException e) {
												e.printStackTrace();
											} catch (NoSuchFieldException e) {
												e.printStackTrace();
											}
										}
									}
									
								} else {
									// 読み飛ばす
								}
							}
						} else {
							if (fieldType.isAnnotationPresent(Regex.class)) {
								String subSource = matcher
										.group(entry.getKey());
								List<?> subList = this.process(subSource,
										fieldType);
								
								if (subList.size() > 0) {
									Object obj = subList.get(0);
									
									targetField.set(instance, obj);
								}
							}
						}
					}
				}
				
				resultList.add(instance);
			}
			return resultList;
		} catch (PatternSyntaxException e) {
			//			logger.error("pattern[" + regex.pattern()
			//					+ "] can't compile to java.util.regex.Pattern", e);
			return resultList;
		} catch (InstantiationException e) {
			e.printStackTrace();
			return resultList;
		} catch (IllegalAccessException e) {
			e.printStackTrace();
			return resultList;
		}
		
	}
	
	/**
	 * 第一引数で指定されたテキストコンテンツを第二引数で指定されたJavaBeans(RegexBean)で解析し
	 * 結果を第二引数で指定されたクラスオブジェクトの実態で返します
	 * 
	 * @param <T>
	 *            RegexBean
	 * @param source
	 *            解析対象テキストコンテンツ
	 * @param cls
	 *            RegexBeanクラスオブジェクト
	 * @return 解析結果
	 */
	public <T> T processBySingle(final String source, final Class<T> cls) {
		try {
			T result = cls.newInstance();
			if (source == null) {
				//			logger.error("source is null");
				return result;
			}
			
			if (!cls.isAnnotationPresent(Regex.class)) {
				return result;
			}
			
			Regex regex = cls.getAnnotation(Regex.class);
			
			int flg = 0;
			if (regex.isMultiLine()) {
				flg = flg | Pattern.MULTILINE;
			}
			if (regex.isDoTall()) {
				flg = flg | Pattern.DOTALL;
			}
			if (regex.isCaseInsentive()) {
				flg = flg | Pattern.CASE_INSENSITIVE;
			}
			if (regex.isComments()) {
				flg = flg | Pattern.COMMENTS;
			}
			if (regex.isLiteral()) {
				flg = flg | Pattern.LITERAL;
			}
			if (regex.isUnixLines()) {
				flg = flg | Pattern.UNIX_LINES;
			}
			if (regex.isUnicodeCase()) {
				flg = flg | Pattern.UNICODE_CASE;
			}
			if (regex.isCanonEq()) {
				flg = flg | Pattern.CANON_EQ;
			}
			
			Pattern pattern = null;
			if (cache.containsKey(regex.pattern())) {
				pattern = cache.get(regex.pattern());
			} else {
				if (flg != 0) {
					pattern = Pattern.compile(regex.pattern(), flg);
				} else {
					pattern = Pattern.compile(regex.pattern());
				}
				
				cache.put(regex.pattern(), pattern);
			}
			
			Matcher matcher = pattern.matcher(source);
			
			List<Field> fields = ReflectUtil.getAnnotationPresentedField(cls,
					RegexItem.class);
			
			Map<Integer, Field> fieldMap = new HashMap<Integer, Field>();
			
			for (Field f : fields) {
				fieldMap.put(f.getAnnotation(RegexItem.class).groupIndex(), f);
			}
			
			if (matcher.find()) {
				T instance = cls.newInstance();
				
				for (Entry<Integer, Field> entry : fieldMap.entrySet()) {
					Field targetField = fieldMap.get(entry.getKey());
					if (targetField != null) {
						Class<?> fieldType = targetField.getType();
						
						if (fieldType.equals(String.class)) {
							// インジェクション対象フィールドがStringの場合
							targetField.set(instance,
									matcher.group(entry.getKey()));
						} else if (fieldType.equals(List.class)) {
							// インジェクション対象フィールドがListの場合
							ParameterizedType paramType = (ParameterizedType) targetField
									.getGenericType();
							
							Type[] types = paramType.getActualTypeArguments();
							
							Class<?> componentType = (Class<?>) types[0];
							
							if (componentType.equals(String.class)) {
								// RegexItemにpatternおよびsubindexが設定されている場合のみ処理の対象とする
								RegexItem subRegexItem = targetField
										.getAnnotation(RegexItem.class);
								String subPatternStr = subRegexItem.pattern();
								int subindex = subRegexItem.subindex();
								
								if ((subindex > -1) && (subPatternStr != null)
										&& (!subPatternStr.isEmpty())) {
									List<String> subList = new ArrayList<String>();
									
									String subSource = matcher.group(entry
											.getKey());
									
									Pattern subPattern = Pattern.compile(
											subPatternStr, flg);
									Matcher subMatcher = subPattern
											.matcher(subSource);
									
									while (subMatcher.find()) {
										String subResult = subMatcher
												.group(subindex);
										if (subResult != null
												&& !subResult.isEmpty()) {
											subList.add(subResult);
										} else {
										}
									}
									
									targetField.set(instance, subList);
									
								} else {
									
								}
								
							} else {
								
								if (componentType
										.isAnnotationPresent(Regex.class)) {
									// componentTypeにRegexアノテーションが付加されている場合のみ処理対象とする/
									String subSource = matcher.group(entry
											.getKey());
									
									//									Regex subRegex = componentType
									//											.getAnnotation(Regex.class);
									
									List<?> subList = this.process(subSource,
											componentType);
									
									if (subList.size() > 0) {
										targetField.set(instance, subList);
									} else {
										// 1件もマッチしない場合はunmatchrefを参照して
										// 値の格納を行う
										
										RegexItem refSource = targetField
												.getAnnotation(RegexItem.class);
										if (!refSource.unmatcherRef().isEmpty()) {
											String unmatcherRef = refSource
													.unmatcherRef();
											try {
												Field unmatcherRefField = cls
														.getDeclaredField(unmatcherRef);
												
												if (unmatcherRefField.getType()
														.equals(String.class)) {
													unmatcherRefField
															.set(instance,
																	subSource);
												}
												
											} catch (SecurityException e) {
												e.printStackTrace();
											} catch (NoSuchFieldException e) {
												e.printStackTrace();
											}
										}
									}
									
								} else {
									// 読み飛ばす
								}
							}
						} else {
							if (fieldType.isAnnotationPresent(Regex.class)) {
								String subSource = matcher
										.group(entry.getKey());
								List<?> subList = this.process(subSource,
										fieldType);
								
								if (subList.size() > 0) {
									Object obj = subList.get(0);
									
									targetField.set(instance, obj);
								}
							}
						}
					}
				}
				
				result = (instance);
			}
			
			return result;
		} catch (InstantiationException e) {
			e.printStackTrace();
			return null;
		} catch (IllegalAccessException e) {
			e.printStackTrace();
			
			return null;
		}
	}
	
	public static void main(final String[] args) {
		System.out.println(Pattern.DOTALL);
		System.out.println(0 | Pattern.DOTALL);
		
		System.out.println(0 | Pattern.DOTALL | Pattern.MULTILINE);
		System.out.println(Pattern.MULTILINE);
		System.out.println(0 | Pattern.MULTILINE);
	}
}
