/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.regex.processors;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.dyndns.nuda.tools.regex.processors.ArrayRegexInputSequenceProcessor;
import org.dyndns.nuda.tools.regex.processors.InputSequenceProcessor;
import org.dyndns.nuda.tools.regex.processors.ListRegexInputSequenceProcessor;
import org.dyndns.nuda.tools.regex.processors.ListStringInputSequenceProcessor;
import org.dyndns.nuda.tools.regex.processors.NOPInputSequenceProcessor;
import org.dyndns.nuda.tools.regex.processors.RegexInputSequenceProcessor;
import org.dyndns.nuda.tools.regex.processors.StringInputSequenceProcessor;

public class AutoInputSequenceProcessor
implements InputSequenceProcessor {
    private static List<InputSequenceProcessor> processors = new ArrayList<InputSequenceProcessor>();
    private static InputSequenceProcessor ME;

    static {
        processors.add(new StringInputSequenceProcessor());
        processors.add(new RegexInputSequenceProcessor());
        processors.add(new ListRegexInputSequenceProcessor());
        processors.add(new ListStringInputSequenceProcessor());
        processors.add(new ArrayRegexInputSequenceProcessor());
        ME = null;
    }

    private AutoInputSequenceProcessor() {
    }

    public static InputSequenceProcessor getInstance() {
        if (ME == null) {
            ME = new AutoInputSequenceProcessor();
        }
        return ME;
    }

    @Override
    public boolean accept(Field targetField, String inputSequence) {
        return true;
    }

    public static void addProcessor(InputSequenceProcessor processor) {
        if (processor != null) {
            processors.add(processor);
        }
    }

    @Override
    public void process(Field targetField, Object instance, String inputSequence) {
        if (instance == null) {
            return;
        }
        if (targetField == null) {
            return;
        }
        for (InputSequenceProcessor p : processors) {
            if (!p.accept(targetField, inputSequence)) continue;
            p.process(targetField, instance, inputSequence);
            return;
        }
        new NOPInputSequenceProcessor().process(targetField, instance, inputSequence);
    }
}

