/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.regex.reflection.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.dyndns.nuda.tools.regex.annotation.Regex;
import org.dyndns.nuda.tools.regex.reflection.cache.RegexCache;
import org.dyndns.nuda.tools.regex.util.exception.RegexPatternException;

public class DefaultRegexCache
implements RegexCache {
    private static RegexCache ME = null;
    private static Map<String, Pattern> cache = new HashMap<String, Pattern>();

    public void init() {
    }

    @Override
    public <T> int getRegexFlg(Class<T> cls) throws RegexPatternException {
        if (cls == null) {
            throw new RegexPatternException("\u5bfe\u8c61\u30af\u30e9\u30b9\u304cnull\u306e\u305f\u3081\u6b63\u898f\u8868\u73fe\u30d5\u30e9\u30b0\u3092\u751f\u6210\u3067\u304d\u307e\u305b\u3093");
        }
        if (!cls.isAnnotationPresent(Regex.class)) {
            throw new RegexPatternException("\u5bfe\u8c61\u30af\u30e9\u30b9\u306bRegex\u30a2\u30ce\u30c6\u30fc\u30b7\u30e7\u30f3\u304c\u4ed8\u4e0e\u3055\u308c\u3066\u304a\u308a\u307e\u305b\u3093");
        }
        Regex regex = cls.getAnnotation(Regex.class);
        int flg = 0;
        if (regex.isMultiLine()) {
            flg |= 8;
        }
        if (regex.isDoTall()) {
            flg |= 0x20;
        }
        if (regex.isCaseInsentive()) {
            flg |= 2;
        }
        if (regex.isComments()) {
            flg |= 4;
        }
        if (regex.isLiteral()) {
            flg |= 0x10;
        }
        if (regex.isUnixLines()) {
            flg |= 1;
        }
        if (regex.isUnicodeCase()) {
            flg |= 0x40;
        }
        if (regex.isCanonEq()) {
            flg |= 0x80;
        }
        return flg;
    }

    @Override
    public <T> Pattern createPattern(Class<T> cls) throws RegexPatternException {
        if (cls == null) {
            throw new RegexPatternException("\u5bfe\u8c61\u30af\u30e9\u30b9\u304cnull\u306e\u305f\u3081\u3001\u6b63\u898f\u8868\u73fe\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u751f\u6210\u3067\u304d\u307e\u305b\u3093");
        }
        if (!cls.isAnnotationPresent(Regex.class)) {
            throw new RegexPatternException("\u5bfe\u8c61\u30af\u30e9\u30b9\u306bRegex\u30a2\u30ce\u30c6\u30fc\u30b7\u30e7\u30f3\u304c\u4ed8\u4e0e\u3055\u308c\u3066\u304a\u308a\u307e\u305b\u3093:" + cls.getCanonicalName());
        }
        Regex regex = cls.getAnnotation(Regex.class);
        int flg = this.getRegexFlg(cls);
        Pattern pattern = null;
        if (cache.containsKey(regex.pattern())) {
            pattern = cache.get(regex.pattern());
        } else {
            pattern = flg != 0 ? Pattern.compile(regex.pattern(), flg) : Pattern.compile(regex.pattern());
            cache.put(regex.pattern(), pattern);
        }
        return pattern;
    }

    public static RegexCache getInstance() {
        if (ME == null) {
            ME = new DefaultRegexCache();
        }
        return ME;
    }
}

