/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.regex.reflection.cache;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dyndns.nuda.tools.regex.annotation.RegexItem;
import org.dyndns.nuda.tools.regex.reflection.cache.FieldCache;
import org.dyndns.nuda.tools.util.ReflectUtil;

public class TargetFieldCache
implements FieldCache {
    private static TargetFieldCache ME = null;
    private static Map<Class<?>, Map<Integer, List<Field>>> aCache = new HashMap();

    private TargetFieldCache() {
    }

    public static TargetFieldCache getInstance() {
        if (ME == null) {
            ME = new TargetFieldCache();
        }
        return ME;
    }

    @Override
    public Map<Integer, List<Field>> getTargetFieldList(Class<?> targetClass) {
        if (targetClass == null) {
            return new HashMap<Integer, List<Field>>();
        }
        if (aCache.containsKey(targetClass)) {
            Map<Integer, List<Field>> result = aCache.get(targetClass);
            return result;
        }
        List fields = ReflectUtil.getAnnotationPresentedField(targetClass, RegexItem.class);
        HashMap<Integer, List<Field>> fieldMap = new HashMap<Integer, List<Field>>();
        for (Field f : fields) {
            int groupIndex = f.getAnnotation(RegexItem.class).groupIndex();
            List<Field> fieldList = null;
            if (fieldMap.containsKey(groupIndex)) {
                fieldList = (List)fieldMap.get(groupIndex);
            } else {
                fieldList = new ArrayList();
                fieldMap.put(groupIndex, fieldList);
            }
            fieldList.add(f);
        }
        aCache.put(targetClass, fieldMap);
        return fieldMap;
    }

    public void init() {
    }
}

