package org.dyndns.nuda.tools.regex.processors;

import java.lang.reflect.Field;
import java.util.List;

import org.dyndns.nuda.tools.regex.RegexProcessor;
import org.dyndns.nuda.tools.regex.annotation.Regex;

public class RegexInputSequenceProcessor implements InputSequenceProcessor {

	@Override
	public boolean accept(Field targetField, String inputSequence) {
		Class<?> targetClass = targetField.getType();
		if(targetClass.isAnnotationPresent(Regex.class)) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public void process(Field targetField, Object instance, String inputSequence) {
		//System.out.println("RegexInputSequenceProcessor:process");
		Class<?> targetClass = targetField.getType();
		
		RegexProcessor rp = new RegexProcessor();
		
		//System.out.println("RegexInputSequenceProcessor:process:delegate:" + targetClass + " " + inputSequence);
		
		@SuppressWarnings("rawtypes")
		List result = rp.process(inputSequence, targetClass);
		//System.out.println("RegexInputSequenceProcessor:process:delegateResult:" + result);
		try {
			if(result != null && result.size() > 0) {
				targetField.set(instance, result.get(0));
			}
			
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
	}

}
