package org.dyndns.nuda.tools.regex.reflection.cache;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.dyndns.nuda.tools.regex.annotation.RegexItem;
import org.dyndns.nuda.tools.util.ReflectUtil;

public class TargetFieldCache implements FieldCache {
	private static TargetFieldCache ME = null;

	private static Map<Class<?>, Map<Integer, List<Field>>> aCache = new HashMap<Class<?>, Map<Integer, List<Field>>>();

	private TargetFieldCache() {

	}

	public static TargetFieldCache getInstance() {
		if (ME == null) {
			ME = new TargetFieldCache();
		}
		return ME;
	}

	public Map<Integer, List<Field>> getTargetFieldList(Class<?> targetClass) {
		if (targetClass == null) {
			return new HashMap<Integer, List<Field>>();
		}
		if (aCache.containsKey(targetClass)) {
			//System.out.println("use cache");
			Map<Integer, List<Field>> result = aCache.get(targetClass);
			return result;
		} else {
			//System.out.println("create cache");

			List<Field> fields = ReflectUtil.getAnnotationPresentedField(
					targetClass, RegexItem.class);

			Map<Integer, List<Field>> fieldMap = new HashMap<Integer, List<Field>>();

			for (Field f : fields) {
				int groupIndex = f.getAnnotation(RegexItem.class).groupIndex();

				List<Field> fieldList = null;
				if (fieldMap.containsKey(groupIndex)) {
					fieldList = fieldMap.get(groupIndex);
				} else {
					fieldList = new ArrayList<Field>();
					fieldMap.put(groupIndex, fieldList);
				}
				fieldList.add(f);
				// fieldMap.put(groupIndex, f);
			}
			aCache.put(targetClass, fieldMap);
			return fieldMap;
		}

	}

	@Override
	public void init() {
		
	}
}
