package org.dyndns.nuda.tools.regex.reflection.cache;

import java.util.regex.Pattern;

import org.dyndns.nuda.tools.regex.annotation.Regex;
import org.dyndns.nuda.tools.regex.util.exception.RegexPatternException;

/**
 * キャッシュを行わないRegexCacheです
 * @author koseki
 *
 */
public class NoCachedRegexCache implements RegexCache {

	private static RegexCache ME = null;
	
	@Override
	public void init() {
		// TODO Auto-generated method stub

	}

	@Override
	public <T> int getRegexFlg(Class<T> cls) throws RegexPatternException {
		if (cls == null) {
			throw new RegexPatternException("対象クラスがnullのため正規表現フラグを生成できません");
		}
		if (!cls.isAnnotationPresent(Regex.class)) {
			throw new RegexPatternException("対象クラスにRegexアノテーションが付与されておりません");
		}
		
		Regex regex = cls.getAnnotation(Regex.class);

		int flg = 0;
		if (regex.isMultiLine()) {
			flg = flg | Pattern.MULTILINE;
		}
		if (regex.isDoTall()) {
			flg = flg | Pattern.DOTALL;
		}
		if (regex.isCaseInsentive()) {
			flg = flg | Pattern.CASE_INSENSITIVE;
		}
		if (regex.isComments()) {
			flg = flg | Pattern.COMMENTS;
		}
		if (regex.isLiteral()) {
			flg = flg | Pattern.LITERAL;
		}
		if (regex.isUnixLines()) {
			flg = flg | Pattern.UNIX_LINES;
		}
		if (regex.isUnicodeCase()) {
			flg = flg | Pattern.UNICODE_CASE;
		}
		if (regex.isCanonEq()) {
			flg = flg | Pattern.CANON_EQ;
		}
		return flg;
	}

	@Override
	public <T> Pattern createPattern(Class<T> cls) throws RegexPatternException {
		if (cls == null) {
			throw new RegexPatternException("対象クラスがnullのため、正規表現オブジェクトを生成できません");
		}
		if (!cls.isAnnotationPresent(Regex.class)) {
			throw new RegexPatternException("対象クラスにRegexアノテーションが付与されておりません:" + cls.getCanonicalName());
		}

		Regex regex = cls.getAnnotation(Regex.class);

		int flg = getRegexFlg(cls);
		
		Pattern pattern = null;
		if (flg != 0) {
			pattern = Pattern.compile(regex.pattern(), flg);
		} else {
			pattern = Pattern.compile(regex.pattern());
		}

		return pattern;
	}
	
	public static RegexCache getInstance() {
		if(ME == null) {
			ME = new DefaultRegexCache();
		}
		return ME;
	}

}
