package org.dyndns.nuda.tools.regex;

import java.io.IOException;
import java.util.List;

import junit.framework.Assert;
import junit.framework.TestCase;

import org.dyndns.nuda.tools.util.StringUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RegexProcessorTest extends TestCase {

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}
	
	@Override
	@Before
	public void setUp() throws Exception {
		System.out.println("start" + " " + getName());
	}

	@Override
	@After
	public void tearDown() throws Exception {
		System.out.println("end  " + " " + getName());
	}

	/**
	 * 再帰的正規表現解析なしの場合に解析が成功することを確認する
	 */
	@Test
	public void testProcess() {
		String testSource = "jdbc:mysql://192.168.0.1:3306/testdb";
		RegexProcessor p = new RegexProcessor();
		List<ConStrRegexBean> resultList = p.process(testSource,
				ConStrRegexBean.class);

		if (resultList.size() == 0) {
			Assert.fail();
		}

		ConStrRegexBean bean = resultList.get(0);
		Assert.assertEquals(bean.toString(), "jdbc", bean.coreName);
		Assert.assertEquals(bean.toString(), "mysql", bean.subProtocol);
		Assert.assertEquals(bean.toString(), "192.168.0.1", bean.host);
		Assert.assertEquals(bean.toString(), "3306", bean.port);
		Assert.assertEquals(bean.toString(), "testdb", bean.schemeName);

	}

	/**
	 * 再帰的正規表現解析ありの場合に解析が成功することを確認する
	 */
	@Test
	public void testProcess02() {
		String testSource = "jdbc:mysql://192.168.0.1:3306/testdb";
		RegexProcessor p = new RegexProcessor();
		List<ConStrRegexBean02> resultList = p.process(testSource,
				ConStrRegexBean02.class);

		if (resultList.size() == 0) {
			Assert.fail();
		}

		ConStrRegexBean02 bean = resultList.get(0);
		Assert.assertEquals(bean.toString(), "jdbc", bean.coreName);
		Assert.assertEquals(bean.toString(), "mysql", bean.subProtocol);

		Assert.assertEquals(bean.toString(), "3306", bean.port);
		Assert.assertEquals(bean.toString(), "testdb", bean.schemeName);

		List<HostRegexBean> host = bean.host;

		if (host.size() == 0) {
			Assert.fail();
		}

		HostRegexBean hostRegexBean = host.get(0);
		Assert.assertEquals(host.toString(), "192", hostRegexBean.segment01);
		Assert.assertEquals(host.toString(), "168", hostRegexBean.segment02);
		Assert.assertEquals(host.toString(), "0", hostRegexBean.segment03);
		Assert.assertEquals(host.toString(), "1", hostRegexBean.segment04);
	}

	/**
	 * 再帰的正規表現解析ありの場合に、対象RegexBeanが単数オブジェクトでも解析が成功することを確認する
	 */
	@Test
	public void testProcess03() {
		String testSource = "jdbc:mysql://192.168.0.1:3306/testdb";
		RegexProcessor p = new RegexProcessor();
		List<ConStrRegexBean03> resultList = p.process(testSource,
				ConStrRegexBean03.class);

		if (resultList.size() == 0) {
			Assert.fail();
		}

		ConStrRegexBean03 bean = resultList.get(0);
		Assert.assertEquals(bean.toString(), "jdbc", bean.coreName);
		Assert.assertEquals(bean.toString(), "mysql", bean.subProtocol);

		Assert.assertEquals(bean.toString(), "3306", bean.port);
		Assert.assertEquals(bean.toString(), "testdb", bean.schemeName);

		HostRegexBean host = bean.host;

		if (host == null) {
			Assert.fail();
		}

		Assert.assertEquals(host.toString(), "192", host.segment01);
		Assert.assertEquals(host.toString(), "168", host.segment02);
		Assert.assertEquals(host.toString(), "0", host.segment03);
		Assert.assertEquals(host.toString(), "1", host.segment04);
	}

	/**
	 * 再帰的正規表現解析ありの場合に、対象RegexBeanが単数オブジェクトでも解析が成功することを確認する
	 */
	@Test
	public void testProcessBySingle01() {
		String testSource = "jdbc:mysql://192.168.0.1:3306/testdb";
		RegexProcessor p = new RegexProcessor();
		ConStrRegexBean03 result = p.processBySingle(testSource,
				ConStrRegexBean03.class);

		if (result == null) {
			Assert.fail();
		}

		// ConStrRegexBean03 bean = resultList.get(0);
		Assert.assertEquals(result.toString(), "jdbc", result.coreName);
		Assert.assertEquals(result.toString(), "mysql", result.subProtocol);

		Assert.assertEquals(result.toString(), "3306", result.port);
		Assert.assertEquals(result.toString(), "testdb", result.schemeName);

		HostRegexBean host = result.host;

		if (host == null) {
			Assert.fail();
		}

		Assert.assertEquals(host.toString(), "192", host.segment01);
		Assert.assertEquals(host.toString(), "168", host.segment02);
		Assert.assertEquals(host.toString(), "0", host.segment03);
		Assert.assertEquals(host.toString(), "1", host.segment04);
	}

	// =====================================================================================

	@Test
	public void testProcess04() {
		RegexProcessor p = new RegexProcessor();

		List<ConStrRegexBean> resultList = p.process(null,
				ConStrRegexBean.class);

		Assert.assertEquals(0, resultList.size());
	}

	@Test
	public void testProcess05() {
		RegexProcessor p = new RegexProcessor();

		List<ConStrRegexBean> resultList = p.process("aaa", null);

		Assert.assertEquals(0, resultList.size());
	}

	@Test
	public void testProcess06() {
		RegexProcessor p = new RegexProcessor();

		List<String> resultList = p.process("aaa", String.class);

		Assert.assertEquals(0, resultList.size());
	}

	@Test
	public void testProcessBySingle02() {
		RegexProcessor p = new RegexProcessor();

		ConStrRegexBean result = p.processBySingle(null, ConStrRegexBean.class);

		Assert.assertNull("", result.coreName);
		Assert.assertNull("", result.subProtocol);
		Assert.assertNull("", result.host);
		Assert.assertNull("", result.port);
		Assert.assertNull("", result.schemeName);
	}

	@Test
	public void testProcessBySingle03() {
		RegexProcessor p = new RegexProcessor();

		ConStrRegexBean result = p.processBySingle("aaa", null);

		Assert.assertNull("", result);
	}

	@Test
	public void testProcessBySingle04() {
		RegexProcessor p = new RegexProcessor();

		String result = p.processBySingle("aaa", String.class);

		Assert.assertEquals("", result);
	}

	public void testMulti01() {
		String testSource = "jdbc:mysql://192.168.0.1:3306/testdb";
		RegexProcessor p = new RegexProcessor();
		ConStrRegexBean04 result = p.processBySingle(testSource,
				ConStrRegexBean04.class);

		if (result == null) {
			Assert.fail();
		}

		// ConStrRegexBean03 bean = resultList.get(0);
		Assert.assertEquals(result.toString(), "jdbc", result.coreName);
		Assert.assertEquals(result.toString(), "mysql", result.subProtocol);

		Assert.assertEquals(result.toString(), "3306", result.port);
		Assert.assertEquals(result.toString(), "testdb", result.schemeName);

		Assert.assertEquals(result.toString(), "192.168.0.1", result.hostStr);

		HostRegexBean host = result.host;

		if (host == null) {
			Assert.fail();
		}

		Assert.assertEquals(host.toString(), "192", host.segment01);
		Assert.assertEquals(host.toString(), "168", host.segment02);
		Assert.assertEquals(host.toString(), "0", host.segment03);
		Assert.assertEquals(host.toString(), "1", host.segment04);

		HostRegexBean host2 = result.host2;

		if (host2 == null) {
			Assert.fail();
		}

		Assert.assertEquals(host2.toString(), "192", host2.segment01);
		Assert.assertEquals(host2.toString(), "168", host2.segment02);
		Assert.assertEquals(host2.toString(), "0", host2.segment03);
		Assert.assertEquals(host2.toString(), "1", host2.segment04);
	}

	public void testArrayString() {
		String path = "org/dyndns/nuda/tools/regex/test.csv";
		
		String source;
		try {
			source = StringUtil.loadString(path);
			
			RegexProcessor rp = new RegexProcessor();

			List<CSVRow> result = rp.process(source, CSVRow.class);

			Assert.assertEquals(1000, result.size());

			Assert.assertEquals("aaa", result.get(0).csvRow.get(0).csv);
			Assert.assertEquals("bbb", result.get(0).csvRow.get(1).csv);
			Assert.assertEquals("ccc", result.get(0).csvRow.get(2).csv);
			Assert.assertEquals("aaa,bbb,ccc", result.get(0).inputSequence);
			
			Assert.assertEquals("ddd", result.get(1).csvRow.get(0).csv);
			Assert.assertEquals("eee", result.get(1).csvRow.get(1).csv);
			Assert.assertEquals("fff", result.get(1).csvRow.get(2).csv);
			Assert.assertEquals("ddd,eee,fff", result.get(1).inputSequence);
			
			for(int i = 2; i <= 998; i++) {
				Assert.assertEquals("ggg", result.get(i).csvRow.get(0).csv);
				Assert.assertEquals("hhh", result.get(i).csvRow.get(1).csv);
				Assert.assertEquals("iii", result.get(i).csvRow.get(2).csv);
				Assert.assertEquals("ggg,hhh,iii", result.get(i).inputSequence);
			}
			
			Assert.assertEquals("xxx", result.get(999).csvRow.get(0).csv);
			Assert.assertEquals("yyy", result.get(999).csvRow.get(1).csv);
			Assert.assertEquals("zzz", result.get(999).csvRow.get(2).csv);
			Assert.assertEquals("xxx,yyy,zzz", result.get(999).inputSequence);
		} catch (IOException e) {
			Assert.fail(e.getMessage());
		}


	}
}
