package org.dyndns.nuda.tools.regex.processors;

import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import junit.framework.Assert;
import junit.framework.TestCase;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ListRegexInputSequenceProcessorTest extends TestCase {

	private InputSequenceProcessor p = null;
	
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
		System.out.println("start" + " " + getName());
		p = new ListRegexInputSequenceProcessor();
	}

	@Override
	@After
	public void tearDown() throws Exception {
		System.out.println("end  " + " " + getName());
	}

	@Test
	public void testAccept() {
		TestRegexBean01 bean = new TestRegexBean01();
		Class<?> testRegexBean01Cls = TestRegexBean01.class;
		try {
			Field f = testRegexBean01Cls.getDeclaredField("target004");
			
			boolean result = p.accept(f, "");
			Assert.assertTrue(result);
		} catch (SecurityException e) {
			e.printStackTrace();
			Assert.fail(e.getMessage());
		} catch (NoSuchFieldException e) {
			Assert.fail(e.getMessage());
		}
	}

	@Test
	public void testProcess() {
		TestRegexBean01 bean = new TestRegexBean01();
		Class<?> testRegexBean01Cls = TestRegexBean01.class;
		try {
			String inputSequence = "abc_def_";
			String expected01 = "abc";
			String expected02 = "def";
			String actual01 = "";
			String actual02 = "";
			
			Pattern ptn = Pattern.compile("(.+?)_");
			Matcher matcher = ptn.matcher(inputSequence);
			
			Field f = testRegexBean01Cls.getDeclaredField("target004");
			
			//while(matcher.find()) {
				p.process(f, bean, inputSequence);
			//}
			
			
			
			//p.process(f, bean, expected02);
			actual01 = bean.target004.get(0).target;
			actual02 = bean.target004.get(1).target;
			
			Assert.assertEquals(expected01, actual01);
			Assert.assertEquals(expected02, actual02);
			
		} catch (SecurityException e) {
			e.printStackTrace();
			Assert.fail(e.getMessage());
		} catch (NoSuchFieldException e) {
			Assert.fail(e.getMessage());
		}
	}

}
