/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.dynamic.compiler;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.dyndns.nuda.dynamic.compiler.CompileTask;
import org.dyndns.nuda.dynamic.compiler.SourceBean;
import org.dyndns.nuda.dynamic.compiler.SourceResolver;
import org.dyndns.nuda.dynamic.compiler.resolver.AutoResolver;
import org.dyndns.nuda.management.RUN_STATE;
import org.dyndns.nuda.plugin.SysPluginLoader;

public class CompileEngine {
    private static RUN_STATE state = RUN_STATE.SLEEP;
    private String className;
    private String sourceCode;
    private CompileTask task = new CompileTask();
    private Class<?> compiledClass;

    public static CompileEngine getInstance(SourceBean sourceBean) {
        return new CompileEngine(sourceBean);
    }

    public static CompileEngine getInstance(SourceResolver resolver) {
        return new CompileEngine(resolver);
    }

    public static CompileEngine getInstance(SourceResolver resolver, Object target) {
        return new CompileEngine(resolver, target);
    }

    public static CompileEngine getInstance(Object target) {
        if (state.equals((Object)RUN_STATE.SLEEP)) {
            new SysPluginLoader().loadPlugin(SourceResolver.class);
            state = RUN_STATE.RUNNING;
        }
        AutoResolver resolver = AutoResolver.getInstance();
        return new CompileEngine(resolver, target);
    }

    public static CompileEngine getInstance(String className, String sourceCode) {
        return new CompileEngine(className, sourceCode);
    }

    private CompileEngine() {
    }

    private CompileEngine(SourceBean sourceBean) {
        this();
        this.className = sourceBean.getClassName();
        this.sourceCode = sourceBean.getSourceCode();
    }

    private CompileEngine(SourceResolver resolver) {
        this();
        SourceBean sourceBean = resolver.resolve();
        this.className = sourceBean.getClassName();
        this.sourceCode = sourceBean.getSourceCode();
    }

    private CompileEngine(SourceResolver resolver, Object target) {
        this();
        resolver.setTarget(target);
        SourceBean sourceBean = resolver.resolve();
        this.className = sourceBean.getClassName();
        this.sourceCode = sourceBean.getSourceCode();
    }

    private CompileEngine(String className, String sourceCode) {
        this();
        this.className = className;
        this.sourceCode = sourceCode;
    }

    public CompileEngine compile() {
        this.compiledClass = this.task.compile(this.className, this.sourceCode);
        return this;
    }

    public <T> T createCompiledInstance() {
        return this.createCompiledInstance(new Class[0], new Object[0]);
    }

    public <T> T createCompiledInstance(Class<?>[] paramTypes, Object[] paramValues) {
        Class<T> targetClass;
        block10: {
            if (this.compiledClass == null) {
                return null;
            }
            targetClass = this.getCompiledClass();
            if (targetClass != null) break block10;
            return null;
        }
        try {
            Constructor<T> constructor = targetClass.getDeclaredConstructor(paramTypes);
            T result = constructor.newInstance(paramValues);
            return result;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> Class<T> getCompiledClass() {
        Class<?> result;
        block3: {
            result = null;
            try {
                if (this.compiledClass != null) break block3;
                return null;
            }
            catch (ClassCastException e) {
                e.printStackTrace();
                return null;
            }
        }
        result = this.compiledClass;
        return result;
    }
}

