/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dyndns.nuda.tools.xml.Context;
import org.dyndns.nuda.tools.xml.ScopeHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultXMLReader<V>
extends DefaultHandler {
    private Stack<ScopeHandler<V>> scopeStack = new Stack();
    private ScopeHandler<V> scope;
    private Context<V> context;

    public DefaultXMLReader(ScopeHandler<V> scope, Context<V> context) {
        this.scope = scope;
        this.context = context;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.scope.characters(this.context, ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.scope = this.scope.changeScope(this.scopeStack, qName);
        this.scope.endElement(this.context, uri, localName, qName);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.scope = this.scope.changeScope(this.scopeStack, qName);
        this.scope.startElement(this.context, uri, localName, qName, attributes);
    }

    public V getResult() {
        return this.context.getValue();
    }

    public void read(InputStream is) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser perser = factory.newSAXParser();
            perser.parse(is, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void read(File file) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser perser = factory.newSAXParser();
            perser.parse(file, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void read(String base) {
        InputStream is = null;
        try {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser perser = factory.newSAXParser();
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(base);
                perser.parse(is, (DefaultHandler)this);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

