package jp.sourceforge.javacpt.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

import jp.sourceforge.javacpt.ComparativePerformanceTest;
import jp.sourceforge.javacpt.Printer;

public class ComparativePerformanceTestImpl implements ComparativePerformanceTest
{

	private String testName;
	private long startMillis;
	private long endMillis;
	private boolean printResultFlag = true;
	private Printer printer = null;

	@SuppressWarnings("unused")
	private ComparativePerformanceTestImpl()
	{
		this.printer = new PrinterImpl();
	}

	public ComparativePerformanceTestImpl(String testName)
	{
		this.testName = testName;
		this.printer = new PrinterImpl();
	}

	public void recordTestStart()
	{
		this.startMillis = System.currentTimeMillis();
	}

	public void recordTestEnd()
	{
		this.endMillis = System.currentTimeMillis();
	}

	public long getResult()
	{
		return this.endMillis - this.startMillis;
	}

	public void setPrintResultFlag(boolean printResultFlag)
	{
		this.printResultFlag = printResultFlag;
	}

	public void printResult()
	{
		if (this.printResultFlag)
		{
			String result = this.testName + " : "
					+ String.valueOf(this.endMillis - this.startMillis) + "milsec.";
			printer.infoPrint(result);
		}
	}

	private void errorPrint(String str)
	{
		printer.errorPrint(str);
	}

	public void repeat(int executeTimes, Object instance, Method executeMethod,
			Object... args)
	{
		for (int i = 0; i < executeTimes; i++)
		{
			try
			{
				executeMethod.invoke(instance, args);
			} catch (IllegalArgumentException e)
			{
				errorPrint("exception catched! : " + String.valueOf(i + 1) + "/"
						+ executeTimes);
				e.printStackTrace();
				break;
			} catch (IllegalAccessException e)
			{
				errorPrint("exception catched! : " + String.valueOf(i + 1) + "/"
						+ executeTimes);
				e.printStackTrace();
				break;
			} catch (InvocationTargetException e)
			{
				errorPrint("exception catched! : " + String.valueOf(i + 1) + "/"
						+ executeTimes);
				e.printStackTrace();
				break;
			}
		}
	}

	public long execute(int executeTimes, Object instance, Method executeMethod,
			Object... args)
	{
		recordTestStart();
		repeat(executeTimes, instance, executeMethod, args);
		recordTestEnd();
		printResult();
		return getResult();
	}

	public Logger getLogger()
	{
		return printer.getLogger();
	}

	public void setLogger(Logger logger)
	{
		printer.setLogger(logger);
	}

}
