/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.javacpt.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import jp.sourceforge.javacpt.ComparativePerformanceTest;
import jp.sourceforge.javacpt.Printer;
import jp.sourceforge.javacpt.impl.PrinterImpl;

public class ComparativePerformanceTestImpl
implements ComparativePerformanceTest {
    private String testName;
    private long startMillis;
    private long endMillis;
    private boolean printResultFlag = true;
    private Printer printer = null;
    public static final int DEFAULT_EXECUTE_TIMES = 1000;
    private int executeTimes = 1000;
    private Object targetInstance = null;

    public ComparativePerformanceTestImpl() {
        this.printer = new PrinterImpl();
    }

    public ComparativePerformanceTestImpl(String testName) {
        this.testName = testName;
        this.printer = new PrinterImpl();
    }

    public void recordTestStart() {
        this.startMillis = System.currentTimeMillis();
    }

    public void recordTestEnd() {
        this.endMillis = System.currentTimeMillis();
    }

    public long getResult() {
        return this.endMillis - this.startMillis;
    }

    public void setPrintResultFlag(boolean printResultFlag) {
        this.printResultFlag = printResultFlag;
    }

    public void printResult() {
        if (this.printResultFlag) {
            String result = this.testName + " : " + String.valueOf(this.endMillis - this.startMillis) + "milsec.";
            this.printer.infoPrint(result);
        }
    }

    public void errorPrint(String str) {
        this.printer.errorPrint(str);
    }

    public void repeat(int executeTimes, Object instance, Method executeMethod, Object ... args) {
        for (int i = 0; i < executeTimes; ++i) {
            try {
                executeMethod.invoke(instance, args);
                continue;
            }
            catch (IllegalArgumentException e) {
                String argsStr = "args : ";
                for (Object each : args) {
                    argsStr = argsStr + each.toString() + ",";
                }
                this.errorPrint("exception catched! : " + String.valueOf(i + 1) + "/" + executeTimes + "(" + argsStr + ")");
                e.printStackTrace();
                break;
            }
            catch (IllegalAccessException e) {
                this.errorPrint("exception catched! : " + String.valueOf(i + 1) + "/" + executeTimes);
                e.printStackTrace();
                break;
            }
            catch (InvocationTargetException e) {
                this.errorPrint("exception catched! : " + String.valueOf(i + 1) + "/" + executeTimes);
                e.printStackTrace();
                break;
            }
        }
    }

    public long execute(int executeTimes, Object instance, Method executeMethod, Object ... args) {
        this.recordTestStart();
        this.repeat(executeTimes, instance, executeMethod, args);
        this.recordTestEnd();
        this.printResult();
        return this.getResult();
    }

    public long execute(Method execuMethod, Object ... args) {
        return this.execute(this.executeTimes, this.targetInstance, execuMethod, args);
    }

    public Logger getLogger() {
        return this.printer.getLogger();
    }

    public void setLogger(Logger logger) {
        this.printer.setLogger(logger);
    }

    public int getExecuteTimes() {
        return this.executeTimes;
    }

    public void setExecuteTimes(int executeTimes) {
        this.executeTimes = executeTimes;
    }

    public Object getTargetInstance() {
        return this.targetInstance;
    }

    public void setTargetInstance(Object targetInstance) {
        this.targetInstance = targetInstance;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }
}

