package org.lightdi.container.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ContainerConfig
{
	private boolean isLoaded = false;
	private String name;
	private String locked;
	private String path;

	private Map<String, ComponentConfig> components = new ConcurrentHashMap<String, ComponentConfig>();

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public String getLocked()
	{
		return locked;
	}

	public void setLocked(String locked)
	{
		this.locked = locked;
	}

	public String getPath()
	{
		return path;
	}

	public void setPath(String path)
	{
		this.path = path;
	}

	public Map<String, ComponentConfig> getComponents()
	{
		return components;
	}

	public void setComponents(Map<String, ComponentConfig> components)
	{
		this.components = components;
	}

	public ComponentConfig getComponent(String componentName)
	{
		return components.get(componentName);
	}

	public boolean isLoaded()
	{
		return isLoaded;
	}

	public void setLoaded(boolean isLoaded)
	{
		this.isLoaded = isLoaded;
	}

}
