package org.lightdi.container;

import java.util.List;
import java.util.Map;

import org.lightdi.container.meta.MetaComponent;
import org.lightdi.container.security.ContainerLockKey;

public interface DIContainer
{

	public static final String DEFAULT_CONTAINER_NAME = "lightdi-container";

	public List<MetaComponent> getMetaComponents();

	public void setMetaComponents(List<MetaComponent> metaComponents);

	public Map<String, Object> getSingletonComponents();

	public void setSingletonComponents(Map<String, Object> singletonComponents);

	public Object getComponent(String componentName);

	public List<Object> getComponents();

	public String getName();

	public void setName(String name);

	public void lock(ContainerLockKey key);

	public void unlock(ContainerLockKey key);

	public boolean isLocked();

}
