/* 
 * Copyright 2009 Kazuhiro Sera. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License. 
 */

package org.lightdi.container.util;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * LoggerUtil<br>
 * <br>
 * 
 * @author Kazuhiro Sera
 * @version 1.0
 */

public final class LoggerUtil
{

	public static final String START = " START";
	public static final String END = " END";
	public static final String ERROR = " ERROR";

	private LoggerUtil()
	{
	}

	public static final void info(Logger logger, String containerName,
			String componentName, String msg, boolean logging)
	{
		if (logging)
			info(logger, containerName, componentName, msg);
	}

	public static final void info(Logger logger, String containerName,
			String componentName, String msg)
	{
		String sourceClass = new Throwable().getStackTrace()[1].getClassName();
		String sourceMethod = new Throwable().getStackTrace()[1].getMethodName();
		logger.logp(Level.INFO, sourceClass, sourceMethod, getPrefixStringValue(
				containerName, componentName)
				+ msg);
	}

	public static final void warn(Logger logger, String containerName,
			String componentName, String msg, boolean logging)
	{
		if (logging)
			warn(logger, containerName, componentName, msg);
	}

	public static final void warn(Logger logger, String containerName,
			String componentName, String msg)
	{
		String sourceClass = new Throwable().getStackTrace()[1].getClassName();
		String sourceMethod = new Throwable().getStackTrace()[1].getMethodName();
		logger.logp(Level.WARNING, sourceClass, sourceMethod, getPrefixStringValue(
				containerName, componentName)
				+ msg);
	}

	public static final void fatal(Logger logger, String containerName,
			String componentName, String msg, boolean logging)
	{
		if (logging)
			fatal(logger, containerName, componentName, msg);
	}

	public static final void fatal(Logger logger, String containerName,
			String componentName, String msg)
	{
		String sourceClass = new Throwable().getStackTrace()[1].getClassName();
		String sourceMethod = new Throwable().getStackTrace()[1].getMethodName();
		logger.logp(Level.SEVERE, sourceClass, sourceMethod, getPrefixStringValue(
				containerName, componentName)
				+ msg);
	}

	public static String getPrefixStringValue(String containerName, String componentName)
	{
		String ret = "";
		if (containerName != null)
			ret += "[" + containerName + "]";
		if (componentName != null)
			ret += "[" + componentName + "]";
		ret += " :: ";
		return ret;
	}

}
