/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.simplefh.impl;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import jp.sourceforge.simplefh.SimpleFileWriter;
import jp.sourceforge.simplefh.util.FileResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFileWriterImpl
implements SimpleFileWriter {
    private String encoding = "MS932";
    private String file = null;
    private String lineBreak = "\r\n";

    @Override
    public void write(String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(this.lineBreak);
        }
        String string = stringBuffer.toString();
        this.write(string);
    }

    @Override
    public void write(List<String> list) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(list.get(i));
            stringBuffer.append(this.lineBreak);
        }
        String string = stringBuffer.toString();
        this.write(string);
    }

    @Override
    public void write(String string) throws IOException {
        byte[] byArray = string.getBytes(this.encoding);
        this.write(byArray);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.file);
            fileOutputStream.write(byArray);
        }
        catch (NullPointerException nullPointerException) {
            try {
                throw new RuntimeException("Output file is required.");
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                FileResourceUtil.close(fileOutputStream);
                throw throwable;
            }
        }
        FileResourceUtil.close(fileOutputStream);
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public void setFile(String string) {
        this.file = string;
    }

    @Override
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public void setLineBreak(String string) {
        this.lineBreak = string;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String string) {
        this.encoding = string;
    }
}

