/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.simplefh.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import jp.sourceforge.simplefh.SimpleFileAccessor;
import jp.sourceforge.simplefh.SimpleFileWriter;
import jp.sourceforge.simplefh.impl.SimpleFileWriterImpl;

public class SimpleFileAccessorImpl
implements SimpleFileAccessor {
    SimpleFileWriter writer = new SimpleFileWriterImpl();
    private static final String BACK_SLASH = "\\";
    private static final String SLASH = "/";
    private static final String PIPE = "|";
    private static final String DIR_SEPARATOR = File.separator;
    private static final String DIR_SEPARATOR_REGEXP = DIR_SEPARATOR.equals("\\") ? "\\\\|/" : "/";

    public String dirname(String string) {
        String[] stringArray = string.split(DIR_SEPARATOR_REGEXP);
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length - 1;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(DIR_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    public String dirname(File file) {
        String string = file.getPath();
        return this.dirname(string);
    }

    public String basename(String string) {
        String[] stringArray = string.split(DIR_SEPARATOR_REGEXP);
        int n = stringArray.length - 1;
        return stringArray[n];
    }

    public String basename(File file) {
        String string = file.getPath();
        return this.basename(string);
    }

    public void copy(String string, String string2) throws IOException {
        FileChannel fileChannel = new FileInputStream(string).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(string2).getChannel();
        fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
    }

    public void copy(File file, String string) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(string).getChannel();
        fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
    }

    public void delete(String string) throws IOException {
        File file = new File(string);
        try {
            this.delete(file);
        }
        catch (IOException iOException) {
            throw new IOException("Cannot delete file : " + string);
        }
    }

    public void delete(File file) throws IOException {
        if (!file.delete()) {
            throw new IOException("Cannot delete file : " + file.getPath());
        }
    }

    public void move(String string, String string2) throws IOException {
        File file = new File(string);
        try {
            this.move(file, string2);
        }
        catch (IOException iOException) {
            throw new IOException("Cannot move file from : " + string + ", to : " + string2);
        }
    }

    public void move(File file, String string) throws IOException {
        if (!file.renameTo(new File(string))) {
            throw new IOException("Cannot move file from : " + file.getPath() + ", to : " + string);
        }
    }

    public void rename(String string, String string2) throws IOException {
        File file = new File(string);
        this.rename(file, string2);
    }

    public void rename(File file, String string) throws IOException {
        if (!file.renameTo(new File(this.dirname(file) + File.pathSeparator + this.basename(file)))) {
            throw new IOException("Cannot rename file from : " + file.getPath() + ", to : " + string);
        }
    }

    public void touch(String string) throws IOException {
        this.writer.setFile(string);
        byte[] byArray = new byte[]{};
        this.writer.write(byArray);
    }

    public void touch(File file) throws IOException {
        String string = file.getPath();
        this.writer.setFile(string);
        byte[] byArray = new byte[]{};
        this.writer.write(byArray);
    }
}

