/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.simplefh.impl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.simplefh.SimpleFileReader;
import jp.sourceforge.simplefh.util.FileResourceUtil;
import org.mozilla.universalchardet.UniversalDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFileReaderImpl
implements SimpleFileReader {
    private String encodingToRead = null;
    private Integer defaultArrayLength = 4096;
    private UniversalDetector detector = new UniversalDetector(null);

    @Override
    public String getDetectedEncoding(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) > 0 && !this.detector.isDone()) {
            this.detector.handleData(byArray, 0, n);
        }
        this.detector.dataEnd();
        return this.detector.getDetectedCharset();
    }

    @Override
    public InputStream getInputStreamFromResourceOrFileSystem(String string) throws FileNotFoundException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            inputStream = new FileInputStream(string);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] read2CharArray(String string) throws IOException {
        Object object;
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            inputStream = this.getInputStreamFromResourceOrFileSystem(string);
            if (this.encodingToRead == null) {
                object = this.getClass().getClassLoader().getResourceAsStream(string);
                if (object == null) {
                    object = new FileInputStream(string);
                }
                this.encodingToRead = this.getDetectedEncoding((InputStream)object);
                FileResourceUtil.close((InputStream)object);
            }
            inputStreamReader = new InputStreamReader(inputStream, this.encodingToRead);
            object = this._getFileContentInCharArray(inputStreamReader, null, this.defaultArrayLength);
        }
        catch (Throwable throwable) {
            FileResourceUtil.close(inputStream);
            FileResourceUtil.close(inputStreamReader);
            throw throwable;
        }
        FileResourceUtil.close(inputStream);
        FileResourceUtil.close(inputStreamReader);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] read2CharArray(File file) throws IOException {
        Object object;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            if (this.encodingToRead == null) {
                object = new FileInputStream(file);
                this.encodingToRead = this.getDetectedEncoding((InputStream)object);
                FileResourceUtil.close((InputStream)object);
            }
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, this.encodingToRead);
            object = this._getFileContentInCharArray(inputStreamReader, null, this.defaultArrayLength);
        }
        catch (Throwable throwable) {
            FileResourceUtil.close(inputStreamReader);
            throw throwable;
        }
        FileResourceUtil.close(inputStreamReader);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read2ByteArray(String string) throws IOException {
        InputStream inputStream = null;
        try {
            Object object;
            inputStream = this.getInputStreamFromResourceOrFileSystem(string);
            if (this.encodingToRead == null) {
                object = this.getClass().getClassLoader().getResourceAsStream(string);
                if (object == null) {
                    object = new FileInputStream(string);
                }
                this.encodingToRead = this.getDetectedEncoding((InputStream)object);
                FileResourceUtil.close((InputStream)object);
            }
            object = this._getFileContentInByteArray(inputStream, null, this.defaultArrayLength);
            byte[] byArray = new String((byte[])object, this.encodingToRead).getBytes("MS932");
            return byArray;
        }
        finally {
            FileResourceUtil.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read2ByteArray(File file) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        byte[] byArray = null;
        try {
            if (this.encodingToRead == null) {
                FileInputStream fileInputStream = new FileInputStream(file);
                this.encodingToRead = this.getDetectedEncoding(fileInputStream);
                FileResourceUtil.close(fileInputStream);
            }
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byArray = new byte[(int)file.length()];
            bufferedInputStream.read(byArray);
        }
        catch (Throwable throwable) {
            FileResourceUtil.close(bufferedInputStream);
            throw throwable;
        }
        FileResourceUtil.close(bufferedInputStream);
        return new String(byArray, this.encodingToRead).getBytes("MS932");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> read2StringLineList(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            Object object;
            inputStream = this.getInputStreamFromResourceOrFileSystem(string);
            if (this.encodingToRead == null) {
                object = this.getClass().getClassLoader().getResourceAsStream(string);
                if (object == null) {
                    object = new FileInputStream(string);
                }
                this.encodingToRead = this.getDetectedEncoding((InputStream)object);
                FileResourceUtil.close((InputStream)object);
            }
            inputStreamReader = new InputStreamReader(inputStream, this.encodingToRead);
            bufferedReader = new BufferedReader(inputStreamReader);
            object = null;
            while ((object = bufferedReader.readLine()) != null) {
                arrayList.add((String)object);
            }
        }
        catch (Throwable throwable) {
            FileResourceUtil.close(inputStream);
            FileResourceUtil.close(inputStreamReader);
            FileResourceUtil.close(bufferedReader);
            throw throwable;
        }
        FileResourceUtil.close(inputStream);
        FileResourceUtil.close(inputStreamReader);
        FileResourceUtil.close(bufferedReader);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> read2StringLineList(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            Object object;
            if (this.encodingToRead == null) {
                object = new FileInputStream(file);
                this.encodingToRead = this.getDetectedEncoding((InputStream)object);
                FileResourceUtil.close((InputStream)object);
            }
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, this.encodingToRead);
            bufferedReader = new BufferedReader(inputStreamReader);
            object = null;
            while ((object = bufferedReader.readLine()) != null) {
                arrayList.add((String)object);
            }
        }
        catch (Throwable throwable) {
            FileResourceUtil.close(fileInputStream);
            FileResourceUtil.close(inputStreamReader);
            FileResourceUtil.close(bufferedReader);
            throw throwable;
        }
        FileResourceUtil.close(fileInputStream);
        FileResourceUtil.close(inputStreamReader);
        FileResourceUtil.close(bufferedReader);
        return arrayList;
    }

    @Override
    public String[] read2StringLineArray(String string) throws IOException {
        List<String> list = this.read2StringLineList(string);
        String[] stringArray = new String[list.size()];
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = list.get(i);
        }
        return stringArray;
    }

    @Override
    public String[] read2StringLineArray(File file) throws IOException {
        List<String> list = this.read2StringLineList(file);
        String[] stringArray = new String[list.size()];
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = list.get(i);
        }
        return stringArray;
    }

    private byte[] _getFileContentInByteArray(InputStream inputStream, byte[] byArray, int n) throws IOException {
        int n2 = byArray == null ? 0 : byArray.length;
        byte[] byArray2 = new byte[n];
        inputStream.read(byArray2);
        Integer n3 = null;
        for (int i = 0; i < n; ++i) {
            if (byArray2[i] != 0) continue;
            n3 = i;
            break;
        }
        byte[] byArray3 = null;
        if (n3 == null) {
            if (n2 == 0) {
                byArray3 = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray3[i] = byArray2[i];
                }
            } else {
                byArray3 = new byte[n2 + n];
                System.arraycopy(byArray, 0, byArray3, 0, n2);
                System.arraycopy(byArray2, 0, byArray3, n2, n);
            }
            return this._getFileContentInByteArray(inputStream, byArray2, n);
        }
        if (n2 == 0) {
            byArray3 = new byte[n3.intValue()];
            for (int i = 0; i < n3; ++i) {
                byArray3[i] = byArray2[i];
            }
        } else {
            byArray3 = new byte[n2 + n3];
            System.arraycopy(byArray, 0, byArray3, 0, n2);
            System.arraycopy(byArray2, 0, byArray3, n2, n3);
        }
        return byArray3;
    }

    private char[] _getFileContentInCharArray(InputStreamReader inputStreamReader, char[] cArray, int n) throws IOException {
        int n2 = cArray == null ? 0 : cArray.length;
        char[] cArray2 = new char[n];
        inputStreamReader.read(cArray2);
        Integer n3 = null;
        for (int i = 0; i < n; ++i) {
            if (cArray2[i] != '\u0000') continue;
            n3 = i;
            break;
        }
        char[] cArray3 = null;
        if (n3 == null) {
            if (n2 == 0) {
                cArray3 = new char[n];
                for (int i = 0; i < n; ++i) {
                    cArray3[i] = cArray2[i];
                }
            } else {
                cArray3 = new char[n2 + n];
                System.arraycopy(cArray, 0, cArray3, 0, n2);
                System.arraycopy(cArray2, 0, cArray3, n2, n);
            }
            return this._getFileContentInCharArray(inputStreamReader, cArray2, n);
        }
        if (n2 == 0) {
            cArray3 = new char[n3.intValue()];
            for (int i = 0; i < n3; ++i) {
                cArray3[i] = cArray2[i];
            }
        } else {
            cArray3 = new char[n2 + n3];
            System.arraycopy(cArray, 0, cArray3, 0, n2);
            System.arraycopy(cArray2, 0, cArray3, n2, n3);
        }
        return cArray3;
    }

    @Override
    public String getEncodingToRead() {
        return this.encodingToRead;
    }

    @Override
    public void setEncodingToRead(String string) {
        this.encodingToRead = string;
    }

    @Override
    public Integer getDefaultArrayLength() {
        return this.defaultArrayLength;
    }

    @Override
    public void setDefaultArrayLength(Integer n) {
        this.defaultArrayLength = n;
    }
}

