/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.biojava.bio.AnnotationTools;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.CardinalityConstraint;
import org.biojava.bio.PropertyConstraint;
import org.biojava.bio.symbol.Location;

public class AnnotationTypeTest
extends TestCase {
    protected Location cc_zero;
    protected Location cc_zero_or_one;
    protected Location cc_one;
    protected Location cc_one_or_more;
    protected Location cc_any;
    protected PropertyConstraint pc_any;
    protected PropertyConstraint pc_class_string;
    protected PropertyConstraint pc_class_list;
    protected PropertyConstraint pc_class_arraylist;
    protected PropertyConstraint pc_exact_fish;
    protected PropertyConstraint pc_exact_dog;
    protected PropertyConstraint pc_enum_animals;
    protected PropertyConstraint pc_enum_birds;
    protected PropertyConstraint pc_enum_primary_colors;
    protected PropertyConstraint pc_enum_warm_colors;
    protected AnnotationType at_any;
    protected AnnotationType at_color;
    protected AnnotationType at_colors;
    protected AnnotationType at_colorsish;
    protected AnnotationType at_color_name;
    protected AnnotationType at_color_dog;

    public AnnotationTypeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.cc_zero = CardinalityConstraint.ZERO;
        this.cc_zero_or_one = CardinalityConstraint.ZERO_OR_ONE;
        this.cc_one = CardinalityConstraint.ONE;
        this.cc_one_or_more = CardinalityConstraint.ONE_OR_MORE;
        this.cc_any = CardinalityConstraint.ANY;
        this.pc_any = PropertyConstraint.ANY;
        this.pc_class_string = new PropertyConstraint.ByClass(String.class);
        this.pc_class_list = new PropertyConstraint.ByClass(List.class);
        this.pc_class_arraylist = new PropertyConstraint.ByClass(ArrayList.class);
        this.pc_exact_fish = new PropertyConstraint.ExactValue("fish");
        this.pc_exact_dog = new PropertyConstraint.ExactValue("dog");
        this.pc_enum_animals = new PropertyConstraint.Enumeration(new Object[]{"dog", "cat", "antelope", "crow", "hawk", "tit"});
        this.pc_enum_birds = new PropertyConstraint.Enumeration(new Object[]{"crow", "hawk", "tit"});
        this.pc_enum_primary_colors = new PropertyConstraint.Enumeration(new Object[]{"red", "green", "blue"});
        this.pc_enum_warm_colors = new PropertyConstraint.Enumeration(new Object[]{"red", "orange", "russet"});
        this.at_any = AnnotationType.ANY;
        this.at_color = new AnnotationType.Impl();
        this.at_color.setConstraints("color", this.pc_enum_primary_colors, this.cc_one);
        this.at_colors = new AnnotationType.Impl();
        this.at_colors.setConstraints("color", this.pc_enum_primary_colors, this.cc_one_or_more);
        this.at_colorsish = new AnnotationType.Impl();
        this.at_colorsish.setConstraints("color", this.pc_enum_primary_colors, this.cc_any);
        this.at_color_name = new AnnotationType.Impl();
        this.at_color_name.setConstraints("color", this.pc_enum_primary_colors, this.cc_one);
        this.at_color_name.setConstraints("name", this.pc_class_string, this.cc_one);
        this.at_color_dog = new AnnotationType.Impl();
        this.at_color_dog.setConstraints("color", this.pc_enum_primary_colors, this.cc_one);
        this.at_color_dog.setConstraints("name", this.pc_exact_dog, this.cc_one);
    }

    public void testClassProperties() {
        AnnotationTypeTest.assertTrue((String)("are subconstraint: " + this.pc_any + ", " + this.pc_any), (boolean)this.pc_any.subConstraintOf(this.pc_any));
        AnnotationTypeTest.assertTrue((String)("are subconstraint: " + this.pc_any + ", " + this.pc_class_string), (boolean)this.pc_any.subConstraintOf(this.pc_class_string));
        AnnotationTypeTest.assertTrue((String)("are subconstraint: " + this.pc_any + ", " + this.pc_class_list), (boolean)this.pc_any.subConstraintOf(this.pc_class_list));
        AnnotationTypeTest.assertTrue((String)("are subconstraint: " + this.pc_any + ", " + this.pc_class_arraylist), (boolean)this.pc_any.subConstraintOf(this.pc_class_arraylist));
        AnnotationTypeTest.assertTrue((String)("not subconstraint: " + this.pc_class_string + ", " + this.pc_any), (!this.pc_class_string.subConstraintOf(this.pc_any) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("are subconstraint: " + this.pc_class_string + ", " + this.pc_class_string), (boolean)this.pc_class_string.subConstraintOf(this.pc_class_string));
        AnnotationTypeTest.assertTrue((String)("not subconstraint: " + this.pc_class_string + ", " + this.pc_class_list), (!this.pc_class_string.subConstraintOf(this.pc_class_list) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("not subconstraint: " + this.pc_class_string + ", " + this.pc_class_arraylist), (!this.pc_class_string.subConstraintOf(this.pc_class_arraylist) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("not subconstraint: " + this.pc_class_list + ", " + this.pc_any), (!this.pc_class_list.subConstraintOf(this.pc_any) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("not subconstraint: " + this.pc_class_list + ", " + this.pc_class_string), (!this.pc_class_list.subConstraintOf(this.pc_class_string) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("are subconstraint: " + this.pc_class_list + ", " + this.pc_class_list), (boolean)this.pc_class_list.subConstraintOf(this.pc_class_list));
        AnnotationTypeTest.assertTrue((String)("are subconstraint: " + this.pc_class_list + ", " + this.pc_class_arraylist), (boolean)this.pc_class_list.subConstraintOf(this.pc_class_arraylist));
        AnnotationTypeTest.assertTrue((String)("not subconstraint: " + this.pc_class_arraylist + ", " + this.pc_any), (!this.pc_class_arraylist.subConstraintOf(this.pc_any) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("not subconstraint: " + this.pc_class_arraylist + ", " + this.pc_class_string), (!this.pc_class_arraylist.subConstraintOf(this.pc_class_string) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("not subconstraint: " + this.pc_class_arraylist + ", " + this.pc_class_list), (!this.pc_class_arraylist.subConstraintOf(this.pc_class_list) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("are subconstraint: " + this.pc_class_arraylist + ", " + this.pc_class_arraylist), (boolean)this.pc_class_arraylist.subConstraintOf(this.pc_class_arraylist));
    }

    public void testExactProperties() {
        AnnotationTypeTest.assertTrue((String)("are subconstraints: " + this.pc_exact_fish + ", " + this.pc_exact_fish), (boolean)this.pc_exact_fish.subConstraintOf(this.pc_exact_fish));
        AnnotationTypeTest.assertTrue((String)("are subconstraints: " + this.pc_exact_dog + ", " + this.pc_exact_dog), (boolean)this.pc_exact_dog.subConstraintOf(this.pc_exact_dog));
        AnnotationTypeTest.assertTrue((String)("not subconstraints: " + this.pc_exact_fish + ", " + this.pc_exact_dog), (!this.pc_exact_fish.subConstraintOf(this.pc_exact_dog) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("not subconstraints: " + this.pc_exact_dog + ", " + this.pc_exact_fish), (!this.pc_exact_dog.subConstraintOf(this.pc_exact_fish) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("not subconstraints: " + this.pc_exact_fish + ", " + this.pc_any), (!this.pc_exact_fish.subConstraintOf(this.pc_any) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("are subconstraints: " + this.pc_any + ", " + this.pc_exact_fish), (boolean)this.pc_any.subConstraintOf(this.pc_exact_fish));
        AnnotationTypeTest.assertTrue((String)("not subconstraints: " + this.pc_exact_fish + ", " + this.pc_class_string), (!this.pc_exact_fish.subConstraintOf(this.pc_class_string) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("are subconstraints: " + this.pc_class_string + ", " + this.pc_exact_fish), (boolean)this.pc_class_string.subConstraintOf(this.pc_exact_fish));
        AnnotationTypeTest.assertTrue((String)("not subconstraints: " + this.pc_exact_fish + ", " + this.pc_class_list), (!this.pc_exact_fish.subConstraintOf(this.pc_class_list) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("not subconstraints: " + this.pc_class_list + ", " + this.pc_exact_fish), (!this.pc_class_list.subConstraintOf(this.pc_exact_fish) ? 1 : 0) != 0);
    }

    public void testEnumProperties() {
        AnnotationTypeTest.assertTrue((String)("are subconstraints: " + this.pc_any + ", " + this.pc_enum_animals), (boolean)this.pc_any.subConstraintOf(this.pc_enum_animals));
        AnnotationTypeTest.assertTrue((String)("not subconstraints: " + this.pc_enum_animals + ", " + this.pc_any), (!this.pc_enum_animals.subConstraintOf(this.pc_any) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("are subconstraints: " + this.pc_enum_animals + ", " + this.pc_enum_animals), (boolean)this.pc_enum_animals.subConstraintOf(this.pc_enum_animals));
        AnnotationTypeTest.assertTrue((String)("are subconstraints: " + this.pc_enum_animals + ", " + this.pc_enum_birds), (boolean)this.pc_enum_animals.subConstraintOf(this.pc_enum_birds));
        AnnotationTypeTest.assertTrue((String)("not subconstraints: " + this.pc_enum_animals + ", " + this.pc_enum_primary_colors), (!this.pc_enum_animals.subConstraintOf(this.pc_enum_primary_colors) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("not subconstraints: " + this.pc_enum_birds + ", " + this.pc_enum_animals), (!this.pc_enum_birds.subConstraintOf(this.pc_enum_animals) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("not subconstraints: " + this.pc_enum_animals + ", " + this.pc_class_string), (!this.pc_enum_animals.subConstraintOf(this.pc_class_string) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("are subconstraints: " + this.pc_class_string + ", " + this.pc_enum_animals), (boolean)this.pc_class_string.subConstraintOf(this.pc_enum_animals));
        AnnotationTypeTest.assertTrue((String)("are subconstraints: " + this.pc_enum_animals + ", " + this.pc_exact_dog), (boolean)this.pc_enum_animals.subConstraintOf(this.pc_exact_dog));
        AnnotationTypeTest.assertTrue((String)("not subconstraints: " + this.pc_exact_dog + ", " + this.pc_enum_animals), (!this.pc_exact_dog.subConstraintOf(this.pc_enum_animals) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("not subconstraints: " + this.pc_enum_primary_colors + ", " + this.pc_exact_dog), (!this.pc_enum_primary_colors.subConstraintOf(this.pc_exact_dog) ? 1 : 0) != 0);
    }

    public void testAllTypes() {
        AnnotationTypeTest.assertTrue((String)("are subconstraints: " + this.at_any + ", " + this.at_color), (boolean)this.at_any.subTypeOf(this.at_color));
        AnnotationTypeTest.assertTrue((String)("not subconstraints: " + this.at_color + ", " + this.at_any), (!this.at_color.subTypeOf(this.at_any) ? 1 : 0) != 0);
    }

    public void testColorTypes() {
        AnnotationTypeTest.assertTrue((String)("are subtypes: " + this.at_colorsish + ", " + this.at_colorsish), (boolean)this.at_colorsish.subTypeOf(this.at_colorsish));
        AnnotationTypeTest.assertTrue((String)("are subtypes: " + this.at_colorsish + ", " + this.at_colors), (boolean)this.at_colorsish.subTypeOf(this.at_colors));
        AnnotationTypeTest.assertTrue((String)("are subtypes: " + this.at_colorsish + ", " + this.at_color), (boolean)this.at_colorsish.subTypeOf(this.at_color));
        AnnotationTypeTest.assertTrue((String)("not subtypes: " + this.at_colors + ", " + this.at_colorsish), (!this.at_colors.subTypeOf(this.at_colorsish) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("are subtypes: " + this.at_colors + ", " + this.at_colors), (boolean)this.at_colors.subTypeOf(this.at_colors));
        AnnotationTypeTest.assertTrue((String)("are subtypes: " + this.at_colors + ", " + this.at_color), (boolean)this.at_colors.subTypeOf(this.at_color));
        AnnotationTypeTest.assertTrue((String)("not subtypes: " + this.at_color + ", " + this.at_colorsish), (!this.at_color.subTypeOf(this.at_colorsish) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("not subtypes: " + this.at_color + ", " + this.at_colors), (!this.at_color.subTypeOf(this.at_colors) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("are subtypes: " + this.at_color + ", " + this.at_color), (boolean)this.at_color.subTypeOf(this.at_color));
    }

    public void testColorName() {
        AnnotationTypeTest.assertTrue((String)("are subtypes: " + this.at_color + ", " + this.at_color), (boolean)this.at_color.subTypeOf(this.at_color));
        AnnotationTypeTest.assertTrue((String)("are subtypes: " + this.at_color + ", " + this.at_color_name), (boolean)this.at_color.subTypeOf(this.at_color_name));
        AnnotationTypeTest.assertTrue((String)("are subtypes: " + this.at_color + ", " + this.at_color), (boolean)this.at_color_dog.subTypeOf(this.at_color_dog));
        AnnotationTypeTest.assertTrue((String)("not subtypes: " + this.at_color_name + ", " + this.at_color), (!this.at_color_name.subTypeOf(this.at_color) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("are subtypes: " + this.at_color_name + ", " + this.at_color_name), (boolean)this.at_color_name.subTypeOf(this.at_color_name));
        AnnotationTypeTest.assertTrue((String)("are subtypes: " + this.at_color_name + ", " + this.at_color_dog), (boolean)this.at_color_name.subTypeOf(this.at_color_dog));
        AnnotationTypeTest.assertTrue((String)("not subtypes: " + this.at_color_dog + ", " + this.at_color), (!this.at_color_dog.subTypeOf(this.at_color) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("not subtypes: " + this.at_color_dog + ", " + this.at_color_name), (!this.at_color_dog.subTypeOf(this.at_color_name) ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((String)("are subtypes: " + this.at_color_dog + ", " + this.at_color_dog), (boolean)this.at_color_dog.subTypeOf(this.at_color_dog));
    }

    public void testEnumerationOverlaps() {
        AnnotationTypeTest.assertTrue((AnnotationTools.intersection(this.pc_enum_primary_colors, this.pc_enum_birds) == PropertyConstraint.NONE ? 1 : 0) != 0);
        AnnotationTypeTest.assertTrue((AnnotationTools.intersection(this.pc_enum_primary_colors, this.pc_enum_warm_colors) != PropertyConstraint.NONE ? 1 : 0) != 0);
    }
}

