/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.biojava.bio.alignment.FlexibleAlignment;
import org.biojava.bio.alignment.SimpleAlignmentElement;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.GappedSequence;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.LocationTools;

public class FlexibleAlignmentTest
extends TestCase {
    static final String[] alignment = new String[]{"A-C", "AGC", "A-A"};
    static final String[] names = new String[]{"MOUSE", "HUMAN", "SCHPO"};
    static final FlexibleAlignment alignDNA = FlexibleAlignmentTest.parse(names, alignment, true);
    static final FlexibleAlignment alignProt = FlexibleAlignmentTest.parse(names, alignment, false);

    public FlexibleAlignmentTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
    }

    public void testDNA() throws Exception {
        List syms = ((BasisSymbol)alignDNA.symbolAt(2)).getSymbols();
        FlexibleAlignmentTest.assertEquals(syms.get(0), (Object)DNATools.getDNA().getGapSymbol());
        FlexibleAlignmentTest.assertEquals(syms.get(1), (Object)DNATools.g());
    }

    public void testProtein() throws Exception {
        List syms = ((BasisSymbol)alignProt.symbolAt(2)).getSymbols();
        FlexibleAlignmentTest.assertEquals(syms.get(0), (Object)ProteinTools.getAlphabet().getGapSymbol());
    }

    private static FlexibleAlignment parse(String[] names, String[] alignment, boolean dna) {
        try {
            ArrayList<SimpleAlignmentElement> sequences = new ArrayList<SimpleAlignmentElement>();
            for (int i = 0; i < alignment.length; ++i) {
                GappedSequence seq = dna ? DNATools.createGappedDNASequence(alignment[i], names[i]) : ProteinTools.createGappedProteinSequence(alignment[i], names[i]);
                SimpleAlignmentElement ae = new SimpleAlignmentElement(names[i], seq, LocationTools.makeLocation(1, alignment[i].length()));
                sequences.add(ae);
            }
            FlexibleAlignment al = new FlexibleAlignment(sequences);
            return al;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

