/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.alignment.AlignmentElement;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;

public class SimpleAlignmentElement
implements AlignmentElement {
    protected Object label;
    protected Location loc;
    protected SymbolList seq;

    public SimpleAlignmentElement(Object label, SymbolList seq, Location loc) throws BioException {
        if (loc.getMax() - loc.getMin() + 1 != seq.length()) {
            throw new BioException("Sequence length and location length do not match");
        }
        this.label = label;
        this.seq = seq;
        this.loc = loc;
    }

    @Override
    public Object getLabel() {
        return this.label;
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    @Override
    public SymbolList getSymbolList() {
        return this.seq;
    }

    @Override
    public void setLoc(Location nLoc) throws BioError {
        if (nLoc.getMax() - nLoc.getMin() + 1 != this.seq.length()) {
            throw new BioError("Sequence length and location length do not match");
        }
        this.loc = nLoc;
    }
}

