/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.TestCase;
import org.biojava.bio.alignment.SubstitutionMatrix;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;

public class SubstitutionMatrixTest
extends TestCase {
    public void testParseSubstitutionMatrix() {
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream("/files/blosum62.mat");
        SubstitutionMatrixTest.assertNotNull((Object)inStream);
        try {
            FiniteAlphabet alphabet = (FiniteAlphabet)AlphabetManager.alphabetForName("PROTEIN-TERM");
            SymbolTokenization symtok = alphabet.getTokenization("token");
            String file = this.readMatrix(inStream);
            SubstitutionMatrix matrix = new SubstitutionMatrix(alphabet, file, "blosum 62");
            Symbol A = symtok.parseToken("A");
            Symbol W = symtok.parseToken("W");
            Symbol D = symtok.parseToken("D");
            SubstitutionMatrixTest.assertEquals((int)matrix.getValueAt(A, A), (int)4);
            SubstitutionMatrixTest.assertEquals((int)matrix.getValueAt(W, D), (int)-4);
        }
        catch (Exception e) {
            SubstitutionMatrixTest.fail((String)e.getMessage());
        }
    }

    private String readMatrix(InputStream stream) throws IOException {
        String newline = System.getProperty("line.separator");
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuffer file = new StringBuffer();
        while (reader.ready()) {
            file.append(reader.readLine());
            file.append(newline);
        }
        return file.toString();
    }
}

