/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.chromatogram;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.biojava.bio.BioError;
import org.biojava.bio.chromatogram.Chromatogram;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;
import org.biojava.utils.ChangeListener;

public abstract class AbstractChromatogram
implements Chromatogram {
    private static int A = 0;
    private static int C = 1;
    private static int G = 2;
    private static int T = 3;
    private int[][] traceSample;
    private int[] maxTraceValue = new int[4];
    private Alignment baseCalls;
    private int significantBits = 0;

    public AbstractChromatogram() {
        this.traceSample = new int[4][];
    }

    @Override
    public int[] getTrace(AtomicSymbol nucleotide) throws IllegalSymbolException {
        return this.traceSample[this.nucToIndex(nucleotide)];
    }

    @Override
    public int getTraceLength() {
        return this.traceSample[0].length;
    }

    @Override
    public int getMax() {
        try {
            return Math.max(Math.max(this.getMax(DNATools.a()), this.getMax(DNATools.c())), Math.max(this.getMax(DNATools.g()), this.getMax(DNATools.t())));
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("Can't happen", ise);
        }
    }

    @Override
    public int getMax(AtomicSymbol nucleotide) throws IllegalSymbolException {
        return this.maxTraceValue[this.nucToIndex(nucleotide)];
    }

    @Override
    public Alignment getBaseCalls() {
        return this.baseCalls;
    }

    @Override
    public int getSequenceLength() {
        return this.baseCalls.length();
    }

    @Override
    public int getSignificantBits() {
        return this.significantBits;
    }

    private final int nucToIndex(AtomicSymbol nuc) throws IllegalSymbolException {
        if (nuc == DNATools.a()) {
            return A;
        }
        if (nuc == DNATools.c()) {
            return C;
        }
        if (nuc == DNATools.g()) {
            return G;
        }
        if (nuc == DNATools.t()) {
            return T;
        }
        throw new IllegalSymbolException("The symbol " + nuc.getName() + " (" + nuc.getClass().getName() + ") is not in the DNA alphabet");
    }

    protected final void setBaseCallAlignment(Alignment align) throws IllegalAlphabetException, IllegalArgumentException, NoSuchElementException {
        SymbolList dna = align.symbolListForLabel(Chromatogram.DNA);
        SymbolList offsets = align.symbolListForLabel(Chromatogram.OFFSETS);
        if (dna.getAlphabet() != DNATools.getDNA()) {
            throw new IllegalAlphabetException("DNA list has inappropriate alphabet");
        }
        if (!(offsets.getAlphabet() instanceof IntegerAlphabet) && !(offsets.getAlphabet() instanceof IntegerAlphabet.SubIntegerAlphabet)) {
            throw new IllegalAlphabetException("Offsets list has inappropriate alphabet");
        }
        this.baseCalls = align;
    }

    protected final void clearTraces() {
        this.maxTraceValue[AbstractChromatogram.T] = Integer.MIN_VALUE;
        this.maxTraceValue[AbstractChromatogram.G] = Integer.MIN_VALUE;
        this.maxTraceValue[AbstractChromatogram.C] = Integer.MIN_VALUE;
        this.maxTraceValue[AbstractChromatogram.A] = Integer.MIN_VALUE;
        this.traceSample[AbstractChromatogram.T] = null;
        this.traceSample[AbstractChromatogram.G] = null;
        this.traceSample[AbstractChromatogram.C] = null;
        this.traceSample[AbstractChromatogram.A] = null;
    }

    protected final void setTrace(AtomicSymbol nuc, int[] trace, int maxVal) throws IllegalArgumentException, IllegalSymbolException {
        int idx = this.nucToIndex(nuc);
        if (trace == null) {
            this.traceSample[idx] = null;
            this.maxTraceValue[idx] = Integer.MIN_VALUE;
        } else {
            int i;
            for (i = 0; i < 4; ++i) {
                if (this.traceSample[i] == null || this.traceSample[i].length == trace.length) continue;
                throw new IllegalArgumentException("All traces must be the same length.  " + trace.length + " != " + this.traceSample[i].length);
            }
            if (maxVal == Integer.MIN_VALUE) {
                maxVal = trace[0];
                for (i = 1; i < trace.length; ++i) {
                    maxVal = Math.max(maxVal, trace[i]);
                }
            }
            this.traceSample[idx] = trace;
            this.maxTraceValue[idx] = maxVal;
        }
    }

    protected final void setBits(int bits) throws IllegalArgumentException {
        if (bits < 0) {
            throw new IllegalArgumentException("Invalid number of significant bits");
        }
        this.significantBits = bits;
    }

    protected abstract AbstractChromatogram reverseComplementInstance();

    @Override
    public Chromatogram reverseComplement() {
        AbstractChromatogram rev = this.reverseComplementInstance();
        try {
            rev.setTrace(DNATools.a(), AbstractChromatogram.reverse(this.traceSample[T]), this.maxTraceValue[T]);
            rev.setTrace(DNATools.c(), AbstractChromatogram.reverse(this.traceSample[G]), this.maxTraceValue[G]);
            rev.setTrace(DNATools.g(), AbstractChromatogram.reverse(this.traceSample[C]), this.maxTraceValue[C]);
            rev.setTrace(DNATools.t(), AbstractChromatogram.reverse(this.traceSample[A]), this.maxTraceValue[A]);
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("Can't happen -- all symbols are explicit and legal", ise);
        }
        Alignment revBC = this.reverseComplementBaseCalls();
        try {
            rev.setBaseCallAlignment(revBC);
        }
        catch (IllegalAlphabetException iae) {
            throw new BioError("Can't happen unless reverseComplementBaseCalls or reverseComplementBaseCallList have been overridden out-of-spec", iae);
        }
        catch (NoSuchElementException nsee) {
            throw new BioError("Can't happen unless reverseComplementBaseCalls or reverseComplementBaseCallList have been overridden out-of-spec", nsee);
        }
        catch (IllegalArgumentException iae) {
            throw new BioError("Can't happen unless reverseComplementBaseCalls or reverseComplementBaseCallList have been overridden out-of-spec", iae);
        }
        rev.setBits(this.significantBits);
        return rev;
    }

    protected Alignment reverseComplementBaseCalls() {
        Alignment current = this.getBaseCalls();
        HashMap revBCMap = new HashMap();
        for (Object curLabel : current.getLabels()) {
            SymbolList revList = this.reverseComplementBaseCallList(curLabel);
            if (revList == null) continue;
            revBCMap.put(curLabel, revList);
        }
        return this.createImmutableAlignment(revBCMap);
    }

    protected SymbolList reverseComplementBaseCallList(Object label) {
        if (label == DNA) {
            try {
                return SymbolListViews.reverse(DNATools.complement(this.getBaseCalls().symbolListForLabel(DNA)));
            }
            catch (IllegalAlphabetException iae) {
                throw new BioError("Can't happen unless the DNA list has been set improperly", iae);
            }
        }
        if (label == OFFSETS) {
            SymbolList curOffsets = this.getBaseCalls().symbolListForLabel(OFFSETS);
            ArrayList<IntegerAlphabet.IntegerSymbol> revOffsets = new ArrayList<IntegerAlphabet.IntegerSymbol>(curOffsets.length());
            IntegerAlphabet alpha = (IntegerAlphabet)curOffsets.getAlphabet();
            for (int i = curOffsets.length(); i > 0; --i) {
                IntegerAlphabet.IntegerSymbol sym = (IntegerAlphabet.IntegerSymbol)curOffsets.symbolAt(i);
                revOffsets.add(alpha.getSymbol(this.getTraceLength() - sym.intValue()));
            }
            try {
                return this.createImmutableSymbolList(alpha, revOffsets);
            }
            catch (IllegalSymbolException ise) {
                throw new BioError("Can't happen -- revOffsets was just created with only symbols from alpha");
            }
        }
        return null;
    }

    protected SymbolList createImmutableSymbolList(Alphabet alpha, List syms) throws IllegalSymbolException, ClassCastException {
        SimpleSymbolList symlist = new SimpleSymbolList(alpha, syms);
        symlist.addChangeListener(ChangeListener.ALWAYS_VETO);
        return symlist;
    }

    protected Alignment createImmutableAlignment(Map labelsToSymLists) throws IllegalArgumentException, ClassCastException {
        SimpleAlignment sa = new SimpleAlignment(labelsToSymLists);
        sa.addChangeListener(ChangeListener.ALWAYS_VETO);
        return sa;
    }

    protected static final int[] reverse(int[] src) {
        int[] dst = new int[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[src.length - i - 1] = src[i];
        }
        return dst;
    }
}

