/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.chromatogram;

import org.biojava.bio.chromatogram.AbstractChromatogram;
import org.biojava.bio.chromatogram.Chromatogram;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.SmallMap;

public class SimpleChromatogram
extends AbstractChromatogram {
    public void setSymbolLists(SymbolList dna, SymbolList offsets) throws IllegalAlphabetException, IllegalArgumentException {
        if (dna.length() != offsets.length()) {
            throw new IllegalArgumentException("The SymbolLists must be the same length");
        }
        SmallMap map = new SmallMap(2);
        map.put(Chromatogram.DNA, dna);
        map.put(Chromatogram.OFFSETS, offsets);
        super.setBaseCallAlignment(super.createImmutableAlignment(map));
    }

    public void setTraceValues(AtomicSymbol nuc, int[] trace, int maxVal) throws IllegalArgumentException, IllegalSymbolException {
        super.setTrace(nuc, trace, maxVal);
    }

    public void clearTraceValues() {
        super.clearTraces();
    }

    public void setSignificantBits(int bits) {
        super.setBits(bits);
    }

    @Override
    protected AbstractChromatogram reverseComplementInstance() {
        return new SimpleChromatogram();
    }
}

