/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.chromatogram.graphic;

import org.biojava.bio.BioError;
import org.biojava.bio.chromatogram.Chromatogram;
import org.biojava.bio.chromatogram.ChromatogramTools;
import org.biojava.bio.chromatogram.graphic.ChromatogramNonlinearScaler;

public class FixedBaseWidthScaler
implements ChromatogramNonlinearScaler {
    private static final boolean DEBUG = false;
    private Chromatogram lastC;
    private int lastSeqLength;
    private final float baseWidth;
    private final boolean centerPeaks;
    private float[] scales;

    public FixedBaseWidthScaler(float width) {
        this(width, false);
    }

    public FixedBaseWidthScaler(float width, boolean centerPeaks) {
        this.baseWidth = width;
        this.centerPeaks = centerPeaks;
        this.lastC = null;
        this.scales = null;
        this.lastSeqLength = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float scale(Chromatogram c, int traceSampleIndex) throws IndexOutOfBoundsException {
        if (traceSampleIndex < 0 || traceSampleIndex >= c.getTraceLength()) {
            throw new IndexOutOfBoundsException("Requested a scale of a trace sample outside of the chromatogram");
        }
        FixedBaseWidthScaler fixedBaseWidthScaler = this;
        synchronized (fixedBaseWidthScaler) {
            this.calcAllScales(c);
            if (traceSampleIndex >= this.scales.length) {
                throw new BioError("This shouldn't happen: a valid trace sample is not included in the calculated scales array.  This is probably due to a failure in dirty checking.");
            }
            return this.scales[traceSampleIndex];
        }
    }

    private synchronized void calcAllScales(Chromatogram c) {
        if (c == null) {
            return;
        }
        if (this.scales != null && this.lastC != null && this.lastC == c && this.scales.length == c.getTraceLength() && this.lastSeqLength == c.getSequenceLength()) {
            return;
        }
        if (this.scales == null || this.scales.length != c.getTraceLength()) {
            this.scales = new float[c.getTraceLength()];
        }
        int[] peaks = ChromatogramTools.getTraceOffsetArray(c);
        int left = 0;
        int center = peaks[0];
        int right = peaks[0] + (int)Math.floor((double)(peaks[1] - peaks[0]) / 2.0);
        this.scaleBase(left, center, right, 0.0f, false);
        for (int i = 1; i < peaks.length - 1; ++i) {
            left = right + 1;
            center = peaks[i];
            right = peaks[i] + (int)Math.floor((double)(peaks[i + 1] - peaks[i]) / 2.0);
            this.scaleBase(left, center, right, (float)i * this.baseWidth, false);
        }
        left = right + 1;
        center = peaks[peaks.length - 1];
        right = c.getTraceLength() - 1;
        this.scaleBase(left, center, right, (float)(peaks.length - 1) * this.baseWidth, true);
        this.lastC = c;
        this.lastSeqLength = c.getSequenceLength();
    }

    private void scaleBase(int left, int center, int right, float nextX, boolean lastBase) {
        if (left > center) {
            throw new BioError("Assertion failure: left > center ; l=" + left + "; c=" + center + "; r=" + right);
        }
        if (center > right) {
            throw new BioError("Assertion failure: center > right ; l=" + left + "; c=" + center + "; r=" + right);
        }
        if (left < 0) {
            throw new BioError("Assertion failure: left < 0 ; l=" + left + "; c=" + center + "; r=" + right);
        }
        if (center < 0) {
            throw new BioError("Assertion failure: center < 0 ; l=" + left + "; c=" + center + "; r=" + right);
        }
        if (right < 0) {
            throw new BioError("Assertion failure: right < 0 ; l=" + left + "; c=" + center + "; r=" + right);
        }
        if (this.centerPeaks) {
            float leftIncrement = this.baseWidth * 0.5f / (float)(center - left);
            for (int i = left; i < center; ++i) {
                this.scales[i] = nextX;
                nextX += leftIncrement;
            }
            float rightIncrement = this.baseWidth * 0.5f / (float)(right - center + (lastBase ? 0 : 1));
            for (int i = center; i <= right; ++i) {
                this.scales[i] = nextX;
                nextX += rightIncrement;
            }
        } else {
            float increment = this.baseWidth / (float)(right - left + (lastBase ? 0 : 1));
            for (int i = left; i <= right; ++i) {
                this.scales[i] = nextX;
                nextX += increment;
            }
        }
    }
}

