/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.dist.AbstractDistribution;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.dist.IgnoreCountsTrainer;
import org.biojava.bio.dist.OrderNDistribution;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractOrderNDistribution
extends AbstractDistribution
implements OrderNDistribution,
Serializable {
    static final long serialVersionUID = 1406135308618188893L;
    private Alphabet alphabet;
    private Alphabet firstA;
    private Alphabet lastA;
    private Distribution nullModel;
    protected transient ChangeForwarder weightForwarder = null;

    @Override
    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport changeSupport = super.getChangeSupport(ct);
        if ((Distribution.WEIGHTS.isMatchingType(ct) || ct.isMatchingType(Distribution.WEIGHTS)) && this.weightForwarder == null) {
            this.weightForwarder = new ChangeForwarder.Retyper(this, changeSupport, Distribution.WEIGHTS);
            for (Distribution dist : this.conditionedDistributions()) {
                dist.addChangeListener(this.weightForwarder, Distribution.WEIGHTS);
            }
        }
        return changeSupport;
    }

    protected AbstractOrderNDistribution(Alphabet alpha) throws IllegalAlphabetException {
        this.alphabet = alpha;
        List aList = alpha.getAlphabets();
        int lb1 = aList.size() - 1;
        this.firstA = aList.size() == 2 ? (Alphabet)aList.get(0) : AlphabetManager.getCrossProductAlphabet(aList.subList(0, lb1));
        this.lastA = (Alphabet)aList.get(lb1);
        this.nullModel = new UniformNullModel();
    }

    @Override
    public Alphabet getConditioningAlphabet() {
        return this.firstA;
    }

    @Override
    public Alphabet getConditionedAlphabet() {
        return this.lastA;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    @Override
    protected double getWeightImpl(AtomicSymbol sym) throws IllegalSymbolException {
        List symL = sym.getSymbols();
        int lb1 = symL.size() - 1;
        AtomicSymbol firstS = symL.size() == 2 ? (AtomicSymbol)symL.get(0) : (AtomicSymbol)this.firstA.getSymbol(symL.subList(0, lb1));
        Distribution dist = this.getDistribution(firstS);
        return dist.getWeight((AtomicSymbol)symL.get(lb1));
    }

    @Override
    public void setWeightImpl(AtomicSymbol sym, double w) throws IllegalSymbolException, ChangeVetoException {
        List symL = sym.getSymbols();
        int lb1 = symL.size() - 1;
        Symbol firstS = symL.size() == 2 ? (Symbol)symL.get(0) : this.firstA.getSymbol(symL.subList(0, lb1));
        Distribution dist = this.getDistribution(firstS);
        dist.setWeight((Symbol)symL.get(lb1), w);
    }

    @Override
    public void setNullModelImpl(Distribution nullModel) {
        this.nullModel = nullModel;
    }

    @Override
    public Distribution getNullModel() {
        return this.nullModel;
    }

    @Override
    public void registerWithTrainer(DistributionTrainerContext dtc) {
        Iterator i = this.conditionedDistributions().iterator();
        while (i.hasNext()) {
            dtc.registerDistribution((Distribution)i.next());
        }
        dtc.registerTrainer(this, new IgnoreCountsTrainer(){

            @Override
            public void addCount(DistributionTrainerContext dtc, AtomicSymbol sym, double count) throws IllegalSymbolException {
                List symL = sym.getSymbols();
                int lb1 = symL.size() - 1;
                Symbol firstS = lb1 == 1 ? (Symbol)symL.get(0) : AbstractOrderNDistribution.this.firstA.getSymbol(symL.subList(0, lb1));
                Distribution dist = AbstractOrderNDistribution.this.getDistribution(firstS);
                dtc.addCount(dist, (Symbol)symL.get(lb1), count);
            }

            @Override
            public double getCount(DistributionTrainerContext dtc, AtomicSymbol sym) throws IllegalSymbolException {
                List symL = sym.getSymbols();
                int lb1 = symL.size() - 1;
                Symbol firstS = lb1 == 1 ? (Symbol)symL.get(0) : AbstractOrderNDistribution.this.firstA.getSymbol(symL.subList(0, lb1));
                Distribution dist = AbstractOrderNDistribution.this.getDistribution(firstS);
                return dtc.getCount(dist, (AtomicSymbol)symL.get(lb1));
            }
        });
    }

    private class UniformNullModel
    extends AbstractDistribution
    implements Serializable {
        private static final long serialVersionUID = -3357793043843515032L;
        private Distribution nullModel;

        private UniformNullModel() {
            this.nullModel = new UniformDistribution((FiniteAlphabet)AbstractOrderNDistribution.this.lastA);
        }

        @Override
        public Alphabet getAlphabet() {
            return AbstractOrderNDistribution.this.getAlphabet();
        }

        @Override
        protected double getWeightImpl(AtomicSymbol sym) throws IllegalSymbolException {
            List symL = sym.getSymbols();
            int lb1 = symL.size() - 1;
            return this.nullModel.getWeight((AtomicSymbol)symL.get(lb1));
        }

        @Override
        protected void setWeightImpl(AtomicSymbol sym, double weight) throws ChangeVetoException {
            throw new ChangeVetoException("Can't change the weight of this null model");
        }

        @Override
        public Distribution getNullModel() {
            return this;
        }

        @Override
        protected void setNullModelImpl(Distribution nullModel) throws IllegalAlphabetException, ChangeVetoException {
            throw new ChangeVetoException("Can't set the null model for NthOrderDistribution.UniformNullModel");
        }
    }
}

