/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.DistributionTools;
import org.biojava.bio.dist.GapDistribution;
import org.biojava.bio.dist.OrderNDistribution;
import org.biojava.bio.dist.OrderNDistributionFactory;
import org.biojava.bio.dist.PairDistribution;
import org.biojava.bio.dist.SimpleDistributionTrainerContext;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;

public class DistSerTest
extends TestCase {
    private double a = 0.1;
    private double g = 0.3;
    private double c = 0.25;
    private double t = 0.35;
    private Distribution dist;
    private Distribution dist2;
    private Distribution gap;
    private Distribution pair;
    private OrderNDistribution orderN;
    private Alphabet comp;

    public DistSerTest(String name) {
        super(name);
    }

    protected void setUp() {
        try {
            this.dist = DistributionFactory.DEFAULT.createDistribution(DNATools.getDNA());
            this.gap = new GapDistribution(DNATools.getDNA());
            this.pair = new PairDistribution(this.dist, this.gap);
            List<FiniteAlphabet> l = Collections.nCopies(3, DNATools.getDNA());
            this.comp = AlphabetManager.getCrossProductAlphabet(l);
            this.orderN = (OrderNDistribution)OrderNDistributionFactory.DEFAULT.createDistribution(this.comp);
        }
        catch (IllegalAlphabetException iae) {
            throw new AssertionFailedError("Can't initialize test distributions " + iae.getMessage());
        }
        try {
            this.dist.setWeight(DNATools.a(), this.a);
            this.dist.setWeight(DNATools.g(), this.g);
            this.dist.setWeight(DNATools.c(), this.c);
            this.dist.setWeight(DNATools.t(), this.t);
            SimpleDistributionTrainerContext dtc = new SimpleDistributionTrainerContext();
            dtc.registerDistribution(this.orderN);
            Iterator i = ((FiniteAlphabet)this.comp).iterator();
            while (i.hasNext()) {
                dtc.addCount(this.orderN, (Symbol)i.next(), 1.0);
            }
            dtc.train();
        }
        catch (IllegalSymbolException ise) {
            throw new AssertionFailedError("Unable to set weights: " + ise.getMessage());
        }
        catch (ChangeVetoException cve) {
            throw new AssertionFailedError("Unable to set weights: " + cve.getMessage());
        }
    }

    public void testSimpleSerialization() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(this.dist);
        oos.flush();
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(os.toByteArray()));
        this.dist2 = (Distribution)ois.readObject();
        ois.close();
        DistSerTest.assertTrue((boolean)DistributionTools.areEmissionSpectraEqual(this.dist, this.dist2));
        DistSerTest.assertEquals((Object)this.dist.getAlphabet(), (Object)this.dist2.getAlphabet());
    }

    public void testGapSerialization() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(this.gap);
        oos.flush();
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(os.toByteArray()));
        this.dist2 = (Distribution)ois.readObject();
        ois.close();
        DistSerTest.assertTrue((boolean)DistributionTools.areEmissionSpectraEqual(this.gap, this.dist2));
    }

    public void testPairSerialization() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(this.pair);
        oos.flush();
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(os.toByteArray()));
        this.dist2 = (Distribution)ois.readObject();
        ois.close();
        DistSerTest.assertTrue((boolean)DistributionTools.areEmissionSpectraEqual(this.pair, this.dist2));
    }

    public void testOrderNSerialization() throws Exception {
        Symbol s;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(this.orderN);
        oos.flush();
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(os.toByteArray()));
        this.dist2 = (Distribution)ois.readObject();
        ois.close();
        DistSerTest.assertTrue((this.orderN.getAlphabet() == this.dist2.getAlphabet() ? 1 : 0) != 0);
        DistSerTest.assertTrue((this.orderN.getConditionedAlphabet() == ((OrderNDistribution)this.dist2).getConditionedAlphabet() ? 1 : 0) != 0);
        DistSerTest.assertTrue((this.orderN.getConditioningAlphabet() == ((OrderNDistribution)this.dist2).getConditioningAlphabet() ? 1 : 0) != 0);
        Iterator i = ((FiniteAlphabet)this.orderN.getConditioningAlphabet()).iterator();
        while (i.hasNext()) {
            s = (Symbol)i.next();
            DistSerTest.assertTrue((boolean)DistributionTools.areEmissionSpectraEqual(this.orderN.getDistribution(s), this.orderN.getDistribution(s)));
        }
        DistSerTest.assertTrue((this.orderN.conditionedDistributions().size() == ((OrderNDistribution)this.dist2).conditionedDistributions().size() ? 1 : 0) != 0);
        i = ((FiniteAlphabet)this.orderN.getConditioningAlphabet()).iterator();
        while (i.hasNext()) {
            s = (Symbol)i.next();
            DistSerTest.assertTrue((boolean)DistributionTools.areEmissionSpectraEqual(((OrderNDistribution)this.dist2).getDistribution(s), ((OrderNDistribution)this.dist2).getDistribution(s)));
        }
        i = ((FiniteAlphabet)this.orderN.getConditioningAlphabet()).iterator();
        while (i.hasNext()) {
            s = (Symbol)i.next();
            DistSerTest.assertTrue((boolean)DistributionTools.areEmissionSpectraEqual(this.orderN.getDistribution(s), ((OrderNDistribution)this.dist2).getDistribution(s)));
        }
    }

    public void testBug2360() throws Exception {
        Distribution d = DistributionFactory.DEFAULT.createDistribution(DNATools.getDNA());
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(boas);
        try {
            oos.writeObject(d);
        }
        catch (NullPointerException npe) {
            DistSerTest.fail((String)"Failed to write Distribution");
        }
    }
}

