/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.GapDistribution;
import org.biojava.bio.dist.PairDistribution;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;

public class DistributionTest
extends TestCase {
    private double delta = 1.0E-5;
    private double a = 0.1;
    private double g = 0.3;
    private double c = 0.25;
    private double t = 0.35;
    private Distribution dist;
    private Distribution gap;
    private Distribution gapDist;

    public DistributionTest(String name) {
        super(name);
    }

    protected void setUp() {
        try {
            this.dist = DistributionFactory.DEFAULT.createDistribution(DNATools.getDNA());
            this.gap = new GapDistribution(DNATools.getDNA());
            this.gapDist = new PairDistribution(this.gap, this.dist);
        }
        catch (IllegalAlphabetException iae) {
            throw new AssertionFailedError("Can't initialize test distributions " + iae.getMessage());
        }
        try {
            this.dist.setWeight(DNATools.a(), this.a);
            this.dist.setWeight(DNATools.g(), this.g);
            this.dist.setWeight(DNATools.c(), this.c);
            this.dist.setWeight(DNATools.t(), this.t);
        }
        catch (IllegalSymbolException ise) {
            throw new AssertionFailedError("Unable to set weights: " + ise.getMessage());
        }
        catch (ChangeVetoException cve) {
            throw new AssertionFailedError("Unable to set weights: " + cve.getMessage());
        }
    }

    public void testSimpleDistribution() {
        try {
            DistributionTest.assertEquals((String)"gap", (double)0.0, (double)this.dist.getWeight(this.dist.getAlphabet().getGapSymbol()), (double)this.delta);
            DistributionTest.assertEquals((String)DNATools.a().toString(), (double)this.a, (double)this.dist.getWeight(DNATools.a()), (double)this.delta);
            DistributionTest.assertEquals((String)DNATools.g().toString(), (double)this.g, (double)this.dist.getWeight(DNATools.g()), (double)this.delta);
            DistributionTest.assertEquals((String)DNATools.c().toString(), (double)this.c, (double)this.dist.getWeight(DNATools.c()), (double)this.delta);
            DistributionTest.assertEquals((String)DNATools.t().toString(), (double)this.t, (double)this.dist.getWeight(DNATools.t()), (double)this.delta);
        }
        catch (IllegalSymbolException ise) {
            throw new AssertionFailedError("Can't retrieve weight: " + ise.getMessage());
        }
    }

    public void testAmbiguities() {
        try {
            HashSet<AtomicSymbol> syms = new HashSet<AtomicSymbol>();
            double tot = 0.0;
            DistributionTest.assertEquals((String)((Object)syms).toString(), (double)tot, (double)this.dist.getWeight(this.dist.getAlphabet().getAmbiguity(syms)), (double)this.delta);
            syms.add(DNATools.a());
            DistributionTest.assertEquals((String)((Object)syms).toString(), (double)(tot += this.a), (double)this.dist.getWeight(this.dist.getAlphabet().getAmbiguity(syms)), (double)this.delta);
            syms.add(DNATools.g());
            DistributionTest.assertEquals((String)((Object)syms).toString(), (double)(tot += this.g), (double)this.dist.getWeight(this.dist.getAlphabet().getAmbiguity(syms)), (double)this.delta);
            syms.add(DNATools.c());
            DistributionTest.assertEquals((String)((Object)syms).toString(), (double)(tot += this.c), (double)this.dist.getWeight(this.dist.getAlphabet().getAmbiguity(syms)), (double)this.delta);
            syms.add(DNATools.t());
            DistributionTest.assertEquals((String)((Object)syms).toString(), (double)(tot += this.t), (double)this.dist.getWeight(this.dist.getAlphabet().getAmbiguity(syms)), (double)this.delta);
        }
        catch (IllegalSymbolException ise) {
            throw new AssertionFailedError("Can't retrieve weight: " + ise.getMessage());
        }
    }

    public void testGapDistribution() {
        try {
            DistributionTest.assertEquals((String)"real-gap", (double)1.0, (double)this.gap.getWeight(AlphabetManager.getGapSymbol()), (double)this.delta);
            DistributionTest.assertEquals((String)"gap", (double)1.0, (double)this.gap.getWeight(this.gap.getAlphabet().getGapSymbol()), (double)this.delta);
            DistributionTest.assertEquals((String)DNATools.a().toString(), (double)1.0, (double)this.gap.getWeight(DNATools.a()), (double)this.delta);
            DistributionTest.assertEquals((String)DNATools.g().toString(), (double)1.0, (double)this.gap.getWeight(DNATools.g()), (double)this.delta);
            DistributionTest.assertEquals((String)DNATools.c().toString(), (double)1.0, (double)this.gap.getWeight(DNATools.c()), (double)this.delta);
            DistributionTest.assertEquals((String)DNATools.t().toString(), (double)1.0, (double)this.gap.getWeight(DNATools.t()), (double)this.delta);
        }
        catch (IllegalSymbolException ise) {
            throw new AssertionFailedError("Can't retrieve weight: " + ise.getMessage());
        }
    }

    public void testGapDist() {
        try {
            Symbol[] syms = new Symbol[2];
            syms[0] = this.gap.getAlphabet().getGapSymbol();
            List<Symbol> symL = Arrays.asList(syms);
            Iterator si = ((FiniteAlphabet)this.dist.getAlphabet()).iterator();
            while (si.hasNext()) {
                Symbol s;
                syms[1] = s = (Symbol)si.next();
                Symbol sym = this.gapDist.getAlphabet().getSymbol(symL);
                DistributionTest.assertEquals((String)sym.toString(), (double)this.gapDist.getWeight(sym), (double)this.dist.getWeight(s), (double)this.delta);
            }
        }
        catch (IllegalSymbolException ise) {
            throw new AssertionFailedError("Can't retrieve weight: " + ise.getMessage());
        }
    }
}

