/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTools;
import org.biojava.bio.dist.SimpleDistribution;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.Symbol;

public class DistributionToolsTest
extends TestCase {
    private Alignment a;
    private Distribution random;
    private String[] sa;
    private Map map;

    public DistributionToolsTest(String name) {
        super(name);
    }

    protected void setUp() {
        try {
            this.sa = new String[]{"CA-TGGG", "AATTGGC", "AATTGGG", "AATTGGC", "AA-TGGG", "AATTGGC", "AATTGGG", "AATTGGC", "AATTGGG", "AATTGGC"};
            this.map = new HashMap(this.sa.length);
            for (int i = 0; i < this.sa.length; ++i) {
                this.map.put(new Integer(i), DNATools.createDNA(this.sa[i]));
            }
            this.a = new SimpleAlignment(this.map);
            this.random = new SimpleDistribution(DNATools.getDNA());
            DistributionTools.randomizeDistribution(this.random);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        this.sa = null;
        this.map = null;
        this.a = null;
        this.random = null;
    }

    public void testDistOverAlignment() {
        try {
            Distribution[] d = DistributionTools.distOverAlignment(this.a, false);
            Distribution[] d2 = DistributionTools.distOverAlignment(this.a, false, 10.0);
            Distribution[] d3 = DistributionTools.distOverAlignment(this.a, true);
            DistributionToolsTest.assertTrue((d[0].getWeight(DNATools.a()) == 0.9 ? 1 : 0) != 0);
            DistributionToolsTest.assertTrue((d[0].getWeight(DNATools.c()) == 0.1 ? 1 : 0) != 0);
            DistributionToolsTest.assertTrue((d[0].getWeight(DNATools.g()) == 0.0 ? 1 : 0) != 0);
            DistributionToolsTest.assertTrue((d[0].getWeight(DNATools.t()) == 0.0 ? 1 : 0) != 0);
            DistributionToolsTest.assertTrue((d[0].getWeight(AlphabetManager.getGapSymbol()) == 0.0 ? 1 : 0) != 0);
            DistributionToolsTest.assertTrue((d2[1].getWeight(DNATools.a()) == 0.625 ? 1 : 0) != 0);
            DistributionToolsTest.assertTrue((d2[1].getWeight(DNATools.c()) == 0.125 ? 1 : 0) != 0);
            DistributionToolsTest.assertTrue((d2[1].getWeight(DNATools.g()) == 0.125 ? 1 : 0) != 0);
            DistributionToolsTest.assertTrue((d2[1].getWeight(DNATools.t()) == 0.125 ? 1 : 0) != 0);
            DistributionToolsTest.assertTrue((d2[1].getWeight(AlphabetManager.getGapSymbol()) == 0.0 ? 1 : 0) != 0);
            DistributionToolsTest.assertEquals((double)0.0, (double)d3[2].getWeight(DNATools.a()), (double)1.0E-6);
            DistributionToolsTest.assertEquals((double)0.0, (double)d3[2].getWeight(DNATools.c()), (double)1.0E-6);
            DistributionToolsTest.assertEquals((double)0.0, (double)d3[2].getWeight(DNATools.g()), (double)1.0E-6);
            DistributionToolsTest.assertEquals((double)0.8, (double)d3[2].getWeight(DNATools.t()), (double)1.0E-6);
            DistributionToolsTest.assertEquals((double)0.2, (double)d3[2].getWeight(AlphabetManager.getGapSymbol()), (double)1.0E-6);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testInformationContent() {
        UniformDistribution d = new UniformDistribution(DNATools.getDNA());
        DistributionToolsTest.assertTrue((DistributionTools.bitsOfInformation(d) == 0.0 ? 1 : 0) != 0);
        DistributionToolsTest.assertTrue((DistributionTools.totalEntropy(d) == 2.0 ? 1 : 0) != 0);
        HashMap map = DistributionTools.shannonEntropy(d, 2.0);
        Iterator i = DNATools.getDNA().iterator();
        while (i.hasNext()) {
            Symbol s = (Symbol)i.next();
            double ent = (Double)map.get(s);
            DistributionToolsTest.assertTrue((ent == 2.0 ? 1 : 0) != 0);
        }
    }

    public void testGenerateSequence() {
        Sequence seq = DistributionTools.generateSequence("seq", this.random, 1000);
        DistributionToolsTest.assertTrue((seq.length() == 1000 ? 1 : 0) != 0);
        Sequence seq2 = DistributionTools.generateSequence("seq", this.random, 30000);
        DistributionToolsTest.assertTrue((seq2.length() == 30000 ? 1 : 0) != 0);
    }
}

