/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.GeneralNthOrderDistribution;
import org.biojava.bio.dist.IndexedNthOrderDistribution;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalAlphabetException;

public class OrderNDistributionFactory
implements DistributionFactory {
    public static final DistributionFactory DEFAULT = new OrderNDistributionFactory(DistributionFactory.DEFAULT);
    private final DistributionFactory df;

    public OrderNDistributionFactory(DistributionFactory df) {
        this.df = df;
    }

    @Override
    public Distribution createDistribution(Alphabet alpha) throws IllegalAlphabetException {
        List aList = alpha.getAlphabets();
        if (aList.size() == 2 && aList.get(0) == DNATools.getDNA()) {
            return new IndexedNthOrderDistribution(alpha, this.df);
        }
        Alphabet conditioned = (Alphabet)aList.get(aList.size() - 1);
        Alphabet conditioning = AlphabetManager.getCrossProductAlphabet(aList.subList(0, aList.size() - 1));
        ArrayList<Alphabet> l = new ArrayList<Alphabet>();
        l.add(conditioning);
        l.add(conditioned);
        alpha = AlphabetManager.getCrossProductAlphabet(l);
        return new GeneralNthOrderDistribution(alpha, this.df);
    }
}

