/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.TranslatedDistribution;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.IllegalSymbolException;

public class TranslatedDistributionTest
extends TestCase {
    private double a = 0.1;
    private double g = 0.3;
    private double c = 0.25;
    private double t = 0.35;
    private double delta = 1.0E-6;

    public TranslatedDistributionTest(String name) {
        super(name);
    }

    public void testWeights() throws Exception {
        try {
            Distribution d1 = DistributionFactory.DEFAULT.createDistribution(DNATools.getDNA());
            d1.setWeight(DNATools.a(), this.a);
            d1.setWeight(DNATools.c(), this.c);
            d1.setWeight(DNATools.g(), this.g);
            d1.setWeight(DNATools.t(), this.t);
            TranslatedDistribution d2 = new TranslatedDistribution(DNATools.complementTable(), d1, DistributionFactory.DEFAULT);
            TranslatedDistributionTest.assertEquals((double)this.a, (double)d2.getWeight(DNATools.t()), (double)this.delta);
            TranslatedDistributionTest.assertEquals((double)this.c, (double)d2.getWeight(DNATools.g()), (double)this.delta);
            TranslatedDistributionTest.assertEquals((double)this.g, (double)d2.getWeight(DNATools.c()), (double)this.delta);
            TranslatedDistributionTest.assertEquals((double)this.t, (double)d2.getWeight(DNATools.a()), (double)this.delta);
            d1.setWeight(DNATools.a(), this.t);
            d1.setWeight(DNATools.c(), this.g);
            d1.setWeight(DNATools.g(), this.c);
            d1.setWeight(DNATools.t(), this.a);
            TranslatedDistributionTest.assertEquals((double)this.a, (double)d2.getWeight(DNATools.a()), (double)this.delta);
            TranslatedDistributionTest.assertEquals((double)this.c, (double)d2.getWeight(DNATools.c()), (double)this.delta);
            TranslatedDistributionTest.assertEquals((double)this.g, (double)d2.getWeight(DNATools.g()), (double)this.delta);
            TranslatedDistributionTest.assertEquals((double)this.t, (double)d2.getWeight(DNATools.t()), (double)this.delta);
        }
        catch (IllegalSymbolException ise) {
            throw new AssertionFailedError("Can't retrieve weight: " + ise.getMessage());
        }
    }
}

