/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DPFactory;
import org.biojava.bio.dp.ProfileHMM;
import org.biojava.bio.dp.SimpleMarkovModel;
import org.biojava.bio.dp.onehead.SingleDP;
import org.biojava.bio.seq.DNATools;

public class DPSerializationTest
extends TestCase {
    public DPSerializationTest(String testName) {
        super(testName);
    }

    public void testDPSerialization() throws Exception {
        ProfileHMM model = new ProfileHMM(DNATools.getDNA(), 5, DistributionFactory.DEFAULT, DistributionFactory.DEFAULT, "test");
        SingleDP singleDP = new SingleDP(model);
        SimpleMarkovModel model2 = new SimpleMarkovModel(2, DNATools.getDNA(), "pair");
        DP pairDP = DPFactory.DEFAULT.createDP(model2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(singleDP);
        oos.writeObject(pairDP);
        oos.flush();
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        DP dp = (DP)ois.readObject();
        DPSerializationTest.assertEquals(singleDP.getClass(), dp.getClass());
        DP dp2 = (DP)ois.readObject();
        DPSerializationTest.assertEquals(pairDP.getClass(), dp2.getClass());
    }
}

