/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.EventCounter;
import org.biojava.bio.dp.SimpleEmissionState;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class EmissionStateEventTest
extends TestCase {
    public void testDistribution_setWeight() {
        try {
            Distribution dist = DistributionFactory.DEFAULT.createDistribution(DNATools.getDNA());
            SimpleEmissionState es = new SimpleEmissionState("test", Annotation.EMPTY_ANNOTATION, new int[]{1}, dist);
            EventCounter everything = new EventCounter("Everything");
            EventCounter distC = new EventCounter("Distribution counter");
            EventCounter advC = new EventCounter("Advance counter");
            es.addChangeListener(everything, ChangeType.UNKNOWN);
            es.addChangeListener(distC, EmissionState.DISTRIBUTION);
            es.addChangeListener(advC, EmissionState.ADVANCE);
            dist.setWeight(DNATools.a(), 0.3);
            dist.setWeight(DNATools.a(), 0.7);
            EmissionStateEventTest.assertEquals((String)("No distribution events vetoed: " + distC + "\n\t" + everything), (int)distC.getPreCounts(), (int)distC.getPostCounts());
            EmissionStateEventTest.assertEquals((String)("No advance events vetoed: " + advC + "\n\t" + everything), (int)advC.getPreCounts(), (int)advC.getPostCounts());
            EmissionStateEventTest.assertEquals((String)("Two distribution events: " + distC + "\n\t" + everything), (int)2, (int)distC.getPostCounts());
            EmissionStateEventTest.assertEquals((String)("No advance events: " + advC + "\n\t" + everything), (int)0, (int)advC.getPostCounts());
        }
        catch (IllegalAlphabetException iae) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Can not create distribution."))).initCause(iae));
        }
        catch (IllegalSymbolException ise) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Can not set weight."))).initCause(ise));
        }
        catch (ChangeVetoException cve) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Prevented from setting weight."))).initCause(cve));
        }
    }

    public void testSetDistribution() {
        try {
            Distribution dist = DistributionFactory.DEFAULT.createDistribution(DNATools.getDNA());
            Distribution dist2 = DistributionFactory.DEFAULT.createDistribution(DNATools.getDNA());
            SimpleEmissionState es = new SimpleEmissionState("test", Annotation.EMPTY_ANNOTATION, new int[]{1}, dist);
            EventCounter everything = new EventCounter("Everything");
            EventCounter distC = new EventCounter("Distribution counter");
            EventCounter advC = new EventCounter("Advance counter");
            es.addChangeListener(everything, ChangeType.UNKNOWN);
            es.addChangeListener(distC, EmissionState.DISTRIBUTION);
            es.addChangeListener(advC, EmissionState.ADVANCE);
            es.setDistribution(dist2);
            EmissionStateEventTest.assertEquals((String)("No distribution events vetoed: " + distC + "\n\t" + everything), (int)distC.getPreCounts(), (int)distC.getPostCounts());
            EmissionStateEventTest.assertEquals((String)("No advance events vetoed: " + advC + "\n\t" + everything), (int)advC.getPreCounts(), (int)advC.getPostCounts());
            EmissionStateEventTest.assertEquals((String)("One distribution event: " + distC + "\n\t" + everything), (int)1, (int)distC.getPostCounts());
            EmissionStateEventTest.assertEquals((String)("No advance events: " + advC + "\n\t" + everything), (int)0, (int)advC.getPostCounts());
        }
        catch (IllegalAlphabetException iae) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Can not create distribution."))).initCause(iae));
        }
        catch (ChangeVetoException cve) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Prevented from setting weight."))).initCause(cve));
        }
    }
}

