/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.dp.EventCounter;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.SimpleDotState;
import org.biojava.bio.dp.SimpleEmissionState;
import org.biojava.bio.dp.SimpleMarkovModel;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class MarkovModelEventTest
extends TestCase {
    public void testAddRemoveState() {
        try {
            SimpleMarkovModel smm = new SimpleMarkovModel(1, DNATools.getDNA(), "add/remove test");
            EventCounter archC = new EventCounter("Architecture counter");
            EventCounter paraC = new EventCounter("Parameter counter");
            smm.addChangeListener(archC, MarkovModel.ARCHITECTURE);
            smm.addChangeListener(paraC, MarkovModel.PARAMETER);
            SimpleDotState ds = new SimpleDotState("d1");
            SimpleEmissionState es = new SimpleEmissionState("e1", Annotation.EMPTY_ANNOTATION, new int[]{1}, DistributionFactory.DEFAULT.createDistribution(DNATools.getDNA()));
            smm.addState(ds);
            MarkovModelEventTest.assertEquals((String)("All architecture events allowed: " + archC), (int)archC.getPreCounts(), (int)archC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("All parameter events allowed: " + paraC), (int)paraC.getPreCounts(), (int)paraC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("One architecture event: " + archC), (int)1, (int)archC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("No parameter events: " + paraC), (int)0, (int)paraC.getPostCounts());
            archC.zeroCounts();
            paraC.zeroCounts();
            smm.addState(es);
            MarkovModelEventTest.assertEquals((String)("All architecture events allowed: " + archC), (int)archC.getPreCounts(), (int)archC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("All parameter events allowed: " + paraC), (int)paraC.getPreCounts(), (int)paraC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("One architecture event: " + archC), (int)1, (int)archC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("No parameter events: " + paraC), (int)0, (int)paraC.getPostCounts());
            archC.zeroCounts();
            paraC.zeroCounts();
            smm.createTransition(ds, es);
            MarkovModelEventTest.assertEquals((String)("All architecture events allowed: " + archC), (int)archC.getPreCounts(), (int)archC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("All parameter events allowed: " + paraC), (int)paraC.getPreCounts(), (int)paraC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("One architecture event: " + archC), (int)1, (int)archC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("No parameter events: " + paraC), (int)0, (int)paraC.getPostCounts());
            archC.zeroCounts();
            paraC.zeroCounts();
            smm.destroyTransition(ds, es);
            MarkovModelEventTest.assertEquals((String)("All architecture events allowed: " + archC), (int)archC.getPreCounts(), (int)archC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("All parameter events allowed: " + paraC), (int)paraC.getPreCounts(), (int)paraC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("One architecture event: " + archC), (int)1, (int)archC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("No parameter events: " + paraC), (int)0, (int)paraC.getPostCounts());
            archC.zeroCounts();
            paraC.zeroCounts();
            smm.removeState(ds);
            smm.removeState(es);
        }
        catch (IllegalAlphabetException iae) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Could not create distributions."))).initCause(iae));
        }
        catch (ChangeVetoException cve) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Could not modify model."))).initCause(cve));
        }
        catch (IllegalSymbolException ise) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Could not modify model."))).initCause(ise));
        }
        catch (IllegalTransitionException ite) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Could not modify model."))).initCause(ite));
        }
    }

    public void testSetWeights() {
        try {
            SimpleMarkovModel smm = new SimpleMarkovModel(1, DNATools.getDNA(), "add/remove test");
            EventCounter everything = new EventCounter("Everything");
            EventCounter archC = new EventCounter("Architecture counter");
            EventCounter paraC = new EventCounter("Parameter counter");
            smm.addChangeListener(everything, ChangeType.UNKNOWN);
            smm.addChangeListener(archC, MarkovModel.ARCHITECTURE);
            smm.addChangeListener(paraC, MarkovModel.PARAMETER);
            SimpleDotState ds = new SimpleDotState("d1");
            SimpleEmissionState es = new SimpleEmissionState("e1", Annotation.EMPTY_ANNOTATION, new int[]{1}, DistributionFactory.DEFAULT.createDistribution(DNATools.getDNA()));
            smm.addState(ds);
            smm.addState(es);
            smm.createTransition(ds, es);
            everything.zeroCounts();
            archC.zeroCounts();
            paraC.zeroCounts();
            smm.setWeights(ds, new UniformDistribution((FiniteAlphabet)smm.getWeights(ds).getAlphabet()));
            MarkovModelEventTest.assertEquals((String)("All architecture events allowed: " + archC + "\n\t" + everything), (int)archC.getPreCounts(), (int)archC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("All parameter events allowed: " + paraC + "\n\t" + everything), (int)paraC.getPreCounts(), (int)paraC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("No architecture event: " + archC + "\n\t" + everything), (int)0, (int)archC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("One parameter events: " + paraC + "\n\t" + everything), (int)1, (int)paraC.getPostCounts());
            everything.zeroCounts();
            archC.zeroCounts();
            paraC.zeroCounts();
            Distribution dist = DistributionFactory.DEFAULT.createDistribution(DNATools.getDNA());
            es.setDistribution(dist);
            MarkovModelEventTest.assertEquals((String)("All architecture events allowed: " + archC + "\n\t" + everything), (int)archC.getPreCounts(), (int)archC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("All parameter events allowed: " + paraC + "\n\t" + everything), (int)paraC.getPreCounts(), (int)paraC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("No architecture event: " + archC + "\n\t" + everything), (int)0, (int)archC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("One parameter events: " + paraC + "\n\t" + everything), (int)1, (int)paraC.getPostCounts());
            everything.zeroCounts();
            archC.zeroCounts();
            paraC.zeroCounts();
            dist.setWeight(DNATools.a(), 0.9);
            dist.setWeight(DNATools.t(), 0.1);
            MarkovModelEventTest.assertEquals((String)("All architecture events allowed: " + archC + "\n\t" + everything), (int)archC.getPreCounts(), (int)archC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("All parameter events allowed: " + paraC + "\n\t" + everything), (int)paraC.getPreCounts(), (int)paraC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("No architecture event: " + archC + "\n\t" + everything), (int)0, (int)archC.getPostCounts());
            MarkovModelEventTest.assertEquals((String)("Two parameter events: " + paraC + "\n\t" + everything), (int)2, (int)paraC.getPostCounts());
        }
        catch (IllegalAlphabetException iae) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Could not create distributions."))).initCause(iae));
        }
        catch (ChangeVetoException cve) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Could not modify model."))).initCause(cve));
        }
        catch (IllegalSymbolException ise) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Could not modify model."))).initCause(ise));
        }
    }
}

