/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.twohead;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dp.BackPointer;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DPMatrix;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.SimpleStatePath;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.StatePath;
import org.biojava.bio.dp.twohead.BackMatrixPairDPCursor;
import org.biojava.bio.dp.twohead.Cell;
import org.biojava.bio.dp.twohead.CellCalculator;
import org.biojava.bio.dp.twohead.CellCalculatorFactory;
import org.biojava.bio.dp.twohead.CellCalculatorFactoryMaker;
import org.biojava.bio.dp.twohead.EmissionCache;
import org.biojava.bio.dp.twohead.LightPairDPCursor;
import org.biojava.bio.dp.twohead.MatrixPairDPCursor;
import org.biojava.bio.dp.twohead.PairDPCursor;
import org.biojava.bio.dp.twohead.PairDPMatrix;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.DoubleAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleGappedSymbolList;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.SmallMap;

public class PairwiseDP
extends DP
implements Serializable {
    private final HashMap emissionCache;
    private final CellCalculatorFactory ccFactory;

    public PairwiseDP(MarkovModel mm, CellCalculatorFactoryMaker ccfm) throws IllegalSymbolException, IllegalTransitionException, BioException {
        super(mm);
        Alphabet alpha = mm.emissionAlphabet();
        this.emissionCache = new HashMap();
        this.emissionCache.put(ScoreType.PROBABILITY, new EmissionCache(alpha, this.getStates(), this.getDotStatesIndex(), ScoreType.PROBABILITY));
        this.emissionCache.put(ScoreType.ODDS, new EmissionCache(alpha, this.getStates(), this.getDotStatesIndex(), ScoreType.ODDS));
        this.emissionCache.put(ScoreType.NULL_MODEL, new EmissionCache(alpha, this.getStates(), this.getDotStatesIndex(), ScoreType.NULL_MODEL));
        this.ccFactory = ccfm.make(this);
    }

    private EmissionCache getEmissionCache(ScoreType scoreType) {
        return (EmissionCache)this.emissionCache.get(scoreType);
    }

    @Override
    public void update() {
        super.update();
        if (this.emissionCache != null) {
            Iterator i = this.emissionCache.values().iterator();
            while (i.hasNext()) {
                ((EmissionCache)i.next()).clear();
            }
        }
    }

    private Cell run(PairDPCursor cursor, CellCalculator cc) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        Cell[][] cells = cursor.press();
        if (cursor.hasNext()) {
            cursor.next(cells);
            cc.initialize(cells);
        }
        while (cursor.hasNext()) {
            cursor.next(cells);
            cc.calcCell(cells);
        }
        return cells[0][0];
    }

    private double runFB(PairDPCursor cursor, CellCalculator cc) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        Cell cell = this.run(cursor, cc);
        State[] states = this.getStates();
        int l = 0;
        MagicalState magicalState = this.getModel().magicalState();
        while (states[l] != magicalState) {
            ++l;
        }
        return cell.scores[l];
    }

    @Override
    public double backward(SymbolList[] seqs, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        return this.backwardMatrix(seqs, scoreType).getScore();
    }

    @Override
    public DPMatrix backwardMatrix(SymbolList[] seqs, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        if (seqs.length != 2) {
            throw new IllegalArgumentException("This DP object only runs on pairs.");
        }
        this.lockModel();
        PairDPMatrix matrix = new PairDPMatrix(this, seqs[0], seqs[1]);
        BackMatrixPairDPCursor cursor = new BackMatrixPairDPCursor(seqs[0], seqs[1], 2, 2, matrix, this.getEmissionCache(scoreType));
        CellCalculator cc = this.ccFactory.backwards(scoreType);
        double score = this.runFB(cursor, cc);
        this.unlockModel();
        matrix.setScore(score);
        return matrix;
    }

    @Override
    public DPMatrix backwardMatrix(SymbolList[] seqs, DPMatrix d, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        return this.backwardMatrix(seqs, scoreType);
    }

    @Override
    public double forward(SymbolList[] seqs, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        if (seqs.length != 2) {
            throw new IllegalArgumentException("This DP object only runs on pairs.");
        }
        this.lockModel();
        LightPairDPCursor cursor = new LightPairDPCursor(seqs[0], seqs[1], 2, 2, this.getStates().length, this.getEmissionCache(scoreType));
        CellCalculator cc = this.ccFactory.forwards(scoreType);
        double score = this.runFB(cursor, cc);
        this.unlockModel();
        return score;
    }

    @Override
    public DPMatrix forwardMatrix(SymbolList[] seqs, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        if (seqs.length != 2) {
            throw new IllegalArgumentException("This DP object only runs on pairs.");
        }
        this.lockModel();
        PairDPMatrix matrix = new PairDPMatrix(this, seqs[0], seqs[1]);
        MatrixPairDPCursor cursor = new MatrixPairDPCursor(seqs[0], seqs[1], 2, 2, matrix, this.getEmissionCache(scoreType));
        CellCalculator cc = this.ccFactory.forwards(scoreType);
        double score = this.runFB(cursor, cc);
        matrix.setScore(score);
        this.unlockModel();
        return matrix;
    }

    @Override
    public DPMatrix forwardMatrix(SymbolList[] seqs, DPMatrix d, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        return this.forwardMatrix(seqs, scoreType);
    }

    @Override
    public StatePath viterbi(SymbolList[] seqs, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        if (seqs.length != 2) {
            throw new IllegalArgumentException("This DP object only runs on pairs.");
        }
        this.lockModel();
        SymbolList seq0 = seqs[0];
        SymbolList seq1 = seqs[1];
        MagicalState magic = this.getModel().magicalState();
        BackPointer TERMINAL_BP = new BackPointer(magic);
        LightPairDPCursor cursor = new LightPairDPCursor(seq0, seq1, 2, 2, this.getStates().length, this.getEmissionCache(scoreType));
        CellCalculator cc = this.ccFactory.viterbi(scoreType, TERMINAL_BP);
        Cell currentCell = this.run(cursor, cc);
        int l = 0;
        State[] states = this.getStates();
        MagicalState magicalState = this.getModel().magicalState();
        while (states[l] != magicalState) {
            ++l;
        }
        BackPointer[] bpCol = currentCell.backPointers;
        BackPointer bp = bpCol[l];
        ArrayList<State> statel = new ArrayList<State>();
        SimpleGappedSymbolList gap0 = new SimpleGappedSymbolList(seq0);
        SimpleGappedSymbolList gap1 = new SimpleGappedSymbolList(seq1);
        int i0 = seq0.length() + 1;
        int i1 = seq1.length() + 1;
        BackPointer bpi = bp.back;
        while (bpi != TERMINAL_BP) {
            try {
                statel.add(bpi.state);
                if (bpi.state instanceof EmissionState) {
                    int[] advance = ((EmissionState)bpi.state).getAdvance();
                    if (advance[0] == 0) {
                        gap0.addGapInSource(i0);
                    } else {
                        --i0;
                    }
                    if (advance[1] == 0) {
                        gap1.addGapInSource(i1);
                    } else {
                        --i1;
                    }
                }
            }
            catch (IndexOutOfBoundsException ie) {
                while (bpi != TERMINAL_BP) {
                    bpi = bpi.back;
                }
                throw new BioError(ie);
            }
            bpi = bpi.back;
        }
        double[] scoreA = new double[statel.size()];
        SmallMap aMap = new SmallMap();
        aMap.put(seq0, gap0);
        aMap.put(seq1, gap1);
        SimpleAlignment ali = new SimpleAlignment(aMap);
        SimpleGappedSymbolList gappedAli = new SimpleGappedSymbolList(ali);
        int di = statel.size() - 1;
        int dj = ali.length() + 1;
        BackPointer bpi2 = bp.back;
        while (bpi2 != TERMINAL_BP) {
            scoreA[di] = bpi2.score;
            if (bpi2.state instanceof EmissionState) {
                --dj;
            } else {
                gappedAli.addGapInSource(dj);
            }
            --di;
            bpi2 = bpi2.back;
        }
        Collections.reverse(statel);
        SimpleSymbolList statesSL = new SimpleSymbolList(this.getModel().stateAlphabet(), statel);
        SymbolList scoresSL = DoubleAlphabet.fromArray(scoreA);
        SimpleStatePath sp = new SimpleStatePath(currentCell.scores[l], gappedAli, statesSL, scoresSL);
        this.unlockModel();
        return sp;
    }
}

