/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.glyph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.biojava.bio.gui.glyph.Glyph;

public class ArrowGlyph
implements Glyph {
    private Paint fillPaint;
    private Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    private Shape arrowShape;

    public ArrowGlyph() {
        this.fillPaint = Color.BLUE;
    }

    public ArrowGlyph(Rectangle2D.Float bounds) {
        this();
        this.setBounds(bounds);
    }

    @Override
    public Rectangle2D.Float getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Rectangle2D.Float r) {
        if (this.bounds.equals(r)) {
            return;
        }
        float q1 = r.height * 0.25f;
        float q2 = r.height * 0.5f;
        float q3 = r.height * 0.75f;
        float arrowHeadSize = r.height;
        GeneralPath p = new GeneralPath();
        if (r.width - arrowHeadSize > 0.0f) {
            p.moveTo(r.x, r.y + q1);
            p.lineTo(r.x + r.width - arrowHeadSize, r.y + q1);
            p.lineTo(r.x + r.width - arrowHeadSize, r.y);
            p.lineTo(r.x + r.width, r.y + q2);
            p.lineTo(r.x + r.width - arrowHeadSize, r.y + r.height);
            p.lineTo(r.x + r.width - arrowHeadSize, r.y + q3);
            p.lineTo(r.x, r.y + q3);
        } else {
            p.moveTo(r.x, r.y + q1);
            p.lineTo(r.x + r.width, r.y + q1);
            p.lineTo(r.x + r.width, r.y + q3);
            p.lineTo(r.x, r.y + q3);
        }
        p.closePath();
        this.arrowShape = p;
        this.bounds = r;
    }

    @Override
    public void render(Graphics2D g) {
        if (this.arrowShape != null) {
            g.setPaint(this.fillPaint);
            g.fill(this.arrowShape);
        }
    }
}

