/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.gui.sequence.BeadFeatureRenderer;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.OptimizableFilter;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractBeadRenderer
extends AbstractChangeable
implements BeadFeatureRenderer,
Serializable {
    public static final ChangeType DISPLACEMENT = new ChangeType("The displacement of the features has changed", "org.biojava.bio.gui.sequence.AbstractBeadRenderer", "DISPLACEMENT", SequenceRenderContext.LAYOUT);
    public static final ChangeType DEPTH = new ChangeType("The depth of the renderer has changed", "org.biojava.bio.gui.sequence.AbstractBeadRenderer", "DEPTH", SequenceRenderContext.LAYOUT);
    public static final ChangeType OUTLINE = new ChangeType("The outline of the features has changed", "org.biojava.bio.gui.sequence.AbstractBeadRenderer", "OUTLINE", SequenceRenderContext.REPAINT);
    public static final ChangeType STROKE = new ChangeType("The stroke of the features has changed", "org.biojava.bio.gui.sequence.AbstractBeadRenderer", "STROKE", SequenceRenderContext.REPAINT);
    public static final ChangeType FILL = new ChangeType("The fill of the features has changed", "org.biojava.bio.gui.sequence.AbstractBeadRenderer", "FILL", SequenceRenderContext.REPAINT);
    protected double beadDepth;
    protected double beadDisplacement;
    protected Paint beadOutline;
    protected Paint beadFill;
    protected Stroke beadStroke;
    protected Map delegates;
    protected Map delegationCache;

    public AbstractBeadRenderer() {
        this(10.0, 0.0, Color.black, Color.black, new BasicStroke());
    }

    public AbstractBeadRenderer(double beadDepth, double beadDisplacement, Paint beadOutline, Paint beadFill, Stroke beadStroke) {
        this.beadDepth = beadDepth;
        this.beadDisplacement = beadDisplacement;
        this.beadOutline = beadOutline;
        this.beadFill = beadFill;
        this.beadStroke = beadStroke;
        this.delegates = new HashMap();
        this.delegationCache = new HashMap();
    }

    @Override
    public FeatureHolder processMouseEvent(FeatureHolder holder, SequenceRenderContext context, MouseEvent mEvent) {
        return holder;
    }

    @Override
    public void renderFeature(Graphics2D g2, Feature f, SequenceRenderContext context) {
        if (this.delegationCache.containsKey(f)) {
            BeadFeatureRenderer cachedRenderer = (BeadFeatureRenderer)this.delegationCache.get(f);
            cachedRenderer.renderBead(g2, f, context);
            return;
        }
        for (FeatureFilter filter : this.delegates.keySet()) {
            if (!filter.accept(f)) continue;
            FeatureRenderer delegate = (FeatureRenderer)this.delegates.get(filter);
            delegate.renderFeature(g2, f, context);
            return;
        }
        this.delegationCache.put(f, this);
        this.renderBead(g2, f, context);
    }

    @Override
    public void setDelegateRenderer(OptimizableFilter filter, BeadFeatureRenderer renderer) throws IllegalArgumentException {
        block2: {
            Set delegateFilters;
            block1: {
                this.delegationCache.clear();
                delegateFilters = this.delegates.keySet();
                if (delegateFilters.size() != 0) break block1;
                this.delegates.put(filter, renderer);
                break block2;
            }
            Iterator fi = delegateFilters.iterator();
            if (!fi.hasNext()) break block2;
            OptimizableFilter thisFilter = (OptimizableFilter)fi.next();
            if (!thisFilter.isDisjoint(filter)) {
                throw new IllegalArgumentException("Failed to apply filter as it clashes with existing filter " + thisFilter + " (filters must be disjoint)");
            }
            this.delegates.put(filter, renderer);
        }
    }

    public void removeDelegateRenderer(OptimizableFilter filter) {
        this.delegationCache.clear();
        this.delegates.remove(filter);
    }

    @Override
    public double getDepth(SequenceRenderContext context) {
        Collection delegateRenderers = this.delegates.values();
        double maxDepth = 0.0;
        if (delegateRenderers.size() == 0) {
            return maxDepth + 1.0;
        }
        Iterator ri = delegateRenderers.iterator();
        while (ri.hasNext()) {
            maxDepth = Math.max(maxDepth, ((FeatureRenderer)ri.next()).getDepth(context));
        }
        return maxDepth + 1.0;
    }

    @Override
    public double getBeadDepth() {
        return this.beadDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBeadDepth(double depth) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, DEPTH, new Double(this.beadDepth), new Double(depth)));
                cs.firePreChangeEvent(ce);
                this.beadDepth = depth;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.beadDepth = depth;
        }
    }

    @Override
    public double getBeadDisplacement() {
        return this.beadDisplacement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBeadDisplacement(double displacement) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, DISPLACEMENT, new Double(this.beadDisplacement), new Double(displacement)));
                cs.firePreChangeEvent(ce);
                this.beadDisplacement = displacement;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.beadDisplacement = displacement;
        }
    }

    public Paint getBeadOutline() {
        return this.beadOutline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBeadOutline(Paint outline) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, OUTLINE, outline, this.beadOutline));
                cs.firePreChangeEvent(ce);
                this.beadOutline = outline;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.beadOutline = outline;
        }
    }

    public Stroke getBeadStroke() {
        return this.beadStroke;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBeadStroke(Stroke stroke) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, STROKE, stroke, this.beadStroke));
                cs.firePreChangeEvent(ce);
                this.beadStroke = stroke;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.beadStroke = stroke;
        }
    }

    public Paint getBeadFill() {
        return this.beadFill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBeadFill(Paint fill) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, FILL, fill, this.beadFill));
                cs.firePreChangeEvent(ce);
                this.beadFill = fill;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.beadFill = fill;
        }
    }

    @Override
    public abstract void renderBead(Graphics2D var1, Feature var2, SequenceRenderContext var3);
}

