/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.biojava.bio.gui.sequence.FeatureBlockSequenceRenderer;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.FeatureSource;
import org.biojava.bio.gui.sequence.FilteringRenderer;
import org.biojava.bio.gui.sequence.MultiLineRenderer;
import org.biojava.bio.gui.sequence.PaddingRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.ByLocationMinMaxFeatureComparator;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractPeptideDigestRenderer
extends MultiLineRenderer {
    public static final ChangeType DIGEST = new ChangeType("The peptide digest has changed", "org.biojava.bio.gui.sequence.AbstractPeptideDigestRenderer", "DIGEST", SequenceRenderContext.REPAINT);
    public static final String LANE = "Lane";
    private FeatureSource source;
    private FeatureFilter digestFilter;
    private Map laneMap = new HashMap();
    private int laneCount = 0;
    private int distanceBetween = 0;

    public AbstractPeptideDigestRenderer() {
    }

    public AbstractPeptideDigestRenderer(FeatureSource source) {
        this();
        this.setFeatureSource(source);
    }

    public AbstractPeptideDigestRenderer(FeatureSource source, FeatureFilter filter) {
        this(source);
        this.setFilter(filter);
    }

    public AbstractPeptideDigestRenderer(FeatureSource source, FeatureFilter filter, int distanceBetweenFeatures) {
        this(source, filter);
        this.setDistanceBetweenFeatures(distanceBetweenFeatures);
    }

    public void setFeatureSource(FeatureSource source) {
        this.source = source;
    }

    public FeatureSource getFeatureSource() {
        return this.source;
    }

    public FeatureFilter getFilter() {
        return this.digestFilter;
    }

    public void setFilter(FeatureFilter filter) {
        this.digestFilter = filter;
    }

    public void setDistanceBetweenFeatures(int d) {
        this.distanceBetween = d;
    }

    public int getDistanceBetweenFeatures() {
        return this.distanceBetween;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortPeptidesIntoLanes() throws ChangeVetoException {
        if (this.hasListeners(DIGEST)) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.REPAINT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, DIGEST);
                cs.firePreChangeEvent(ce);
                this.doSortPeptides();
                this.doRefreshRenderers();
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.doSortPeptides();
            this.doRefreshRenderers();
        }
    }

    protected void doRefreshRenderers() throws ChangeVetoException {
        super.clearRenderers();
        for (int j = 1; j <= this.laneCount; ++j) {
            FeatureFilter.And ffilt = new FeatureFilter.And(this.getFilter(), new LaneFeatureFilter(j));
            FeatureBlockSequenceRenderer block = new FeatureBlockSequenceRenderer();
            block.setFeatureRenderer(this.createRenderer(j));
            PaddingRenderer pad = new PaddingRenderer();
            pad.setPadding(1.0);
            pad.setRenderer(new FilteringRenderer(block, ffilt, true));
            this.addRenderer(pad);
        }
    }

    public abstract FeatureRenderer createRenderer(int var1);

    protected void doSortPeptides() {
        this.laneMap.clear();
        FeatureHolder fh = this.source.getFeatureHolder().filter(this.getFilter());
        LinkedList<Feature> ranges = new LinkedList<Feature>();
        Iterator i = fh.features();
        while (i.hasNext()) {
            ranges.add((Feature)i.next());
        }
        Collections.sort(ranges, new ByLocationMinMaxFeatureComparator());
        Integer lane_id = new Integer(1);
        int i2 = 0;
        int pos = 0;
        while (ranges.size() > 0) {
            Feature f = (Feature)ranges.get(i2);
            if (f.getLocation().getMin() > pos) {
                pos = f.getLocation().getMax() + this.distanceBetween;
                ranges.remove(i2);
                this.laneMap.put(f, lane_id);
            } else {
                ++i2;
            }
            if (i2 < ranges.size()) continue;
            i2 = 0;
            pos = 0;
            lane_id = new Integer(lane_id + 1);
        }
        this.laneCount = lane_id;
    }

    private class LaneFeatureFilter
    implements FeatureFilter {
        private int lane;

        public LaneFeatureFilter(int lane) {
            this.lane = lane;
        }

        @Override
        public boolean accept(Feature f) {
            Integer i = (Integer)AbstractPeptideDigestRenderer.this.laneMap.get(f);
            return i != null && i == this.lane;
        }
    }
}

